<?php

/**
 * ZITEO Database Connection
 * Singleton PDO Wrapper
 */

require_once __DIR__ . '/config.php';

class Database
{
    private static ?PDO $instance = null;

    public static function getInstance(): PDO
    {
        if (self::$instance === null) {
            try {
                $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
                $options = [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                ];
                self::$instance = new PDO($dsn, DB_USER, DB_PASS, $options);
            } catch (PDOException $e) {
                if (APP_DEBUG) {
                    die("Database Error: " . $e->getMessage());
                }
                die("Database connection failed.");
            }
        }
        return self::$instance;
    }

    // Prevent cloning
    private function __clone() {}
}

// Helper function
function db(): PDO
{
    return Database::getInstance();
}
