<?php

/**
 * Admin Panel - Dashboard
 * admin.ziteo.in
 */
session_start();
require_once dirname(__DIR__, 2) . '/includes/auth.php';
requireAdmin();

$pdo = db();

// Get stats
$stats = [];
$stmt = $pdo->query("SELECT COUNT(*) as count FROM users");
$stats['users'] = $stmt->fetch()['count'];

$stmt = $pdo->query("SELECT COUNT(*) as count FROM stores");
$stats['stores'] = $stmt->fetch()['count'];

$stmt = $pdo->query("SELECT COUNT(*) as count FROM stores WHERE status = 'pending'");
$stats['pending'] = $stmt->fetch()['count'];

$stmt = $pdo->query("SELECT COUNT(*) as count FROM orders");
$stats['orders'] = $stmt->fetch()['count'];

// Get pending stores
$stmt = $pdo->query("
    SELECT s.*, u.name as owner_name, u.email as owner_email
    FROM stores s
    JOIN users u ON s.user_id = u.id
    WHERE s.status = 'pending'
    ORDER BY s.created_at DESC
    LIMIT 10
");
$pendingStores = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - ZITEO</title>
    <link rel="stylesheet" href="../app/assets/css/dashboard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        .admin-header {
            background: #1e293b;
            color: white;
            padding: 16px 24px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .admin-header .logo {
            color: #25D366;
            font-size: 1.5rem;
            font-weight: 700;
            text-decoration: none;
        }

        .admin-nav {
            display: flex;
            gap: 24px;
        }

        .admin-nav a {
            color: #94a3b8;
            text-decoration: none;
        }

        .admin-nav a:hover,
        .admin-nav a.active {
            color: white;
        }

        .admin-content {
            padding: 24px;
            max-width: 1200px;
            margin: 0 auto;
        }

        .pending-table {
            width: 100%;
            background: white;
            border-radius: 12px;
            overflow: hidden;
        }

        .pending-table th,
        .pending-table td {
            padding: 16px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }

        .pending-table th {
            background: #f8fafc;
            font-weight: 600;
        }

        .action-btn {
            padding: 6px 12px;
            border-radius: 6px;
            border: none;
            cursor: pointer;
            font-weight: 500;
            margin-right: 8px;
        }

        .action-btn.approve {
            background: #22c55e;
            color: white;
        }

        .action-btn.reject {
            background: #ef4444;
            color: white;
        }
    </style>
</head>

<body>
    <header class="admin-header">
        <a href="index.php" class="logo">ZITEO Admin</a>
        <nav class="admin-nav">
            <a href="index.php" class="active">Dashboard</a>
            <a href="stores.php">Stores</a>
            <a href="users.php">Users</a>
            <a href="logout.php">Logout</a>
        </nav>
    </header>

    <main class="admin-content">
        <h1>Dashboard</h1>

        <div class="stats-grid" style="margin: 24px 0;">
            <div class="stat-card">
                <span class="stat-value"><?= $stats['users'] ?></span>
                <span class="stat-label">Users</span>
            </div>
            <div class="stat-card">
                <span class="stat-value"><?= $stats['stores'] ?></span>
                <span class="stat-label">Stores</span>
            </div>
            <div class="stat-card">
                <span class="stat-value"><?= $stats['pending'] ?></span>
                <span class="stat-label">Pending Approval</span>
            </div>
            <div class="stat-card">
                <span class="stat-value"><?= $stats['orders'] ?></span>
                <span class="stat-label">Total Orders</span>
            </div>
        </div>

        <h2>Pending Store Approvals</h2>
        <?php if (empty($pendingStores)): ?>
            <p style="color: #64748b;">No pending stores.</p>
        <?php else: ?>
            <table class="pending-table">
                <thead>
                    <tr>
                        <th>Store Name</th>
                        <th>Slug</th>
                        <th>Owner</th>
                        <th>WhatsApp</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pendingStores as $store): ?>
                        <tr>
                            <td><strong><?= e($store['name']) ?></strong></td>
                            <td><?= e($store['slug']) ?>.my.ziteo.in</td>
                            <td><?= e($store['owner_name']) ?><br><small><?= e($store['owner_email']) ?></small></td>
                            <td>+91 <?= e($store['whatsapp']) ?></td>
                            <td><?= date('d M Y', strtotime($store['created_at'])) ?></td>
                            <td>
                                <form method="POST" action="stores.php" style="display: inline;">
                                    <input type="hidden" name="store_id" value="<?= $store['id'] ?>">
                                    <button type="submit" name="action" value="approve" class="action-btn approve">Approve</button>
                                    <button type="submit" name="action" value="reject" class="action-btn reject">Reject</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </main>
</body>

</html>