<?php

/**
 * Admin Panel - Stores Management
 */
session_start();
require_once dirname(__DIR__, 2) . '/includes/auth.php';
requireAdmin();

$pdo = db();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $storeId = (int)($_POST['store_id'] ?? 0);
    $action = $_POST['action'] ?? '';

    if ($storeId && in_array($action, ['approve', 'reject', 'suspend'])) {
        $status = match ($action) {
            'approve' => 'active',
            'reject' => 'suspended',
            'suspend' => 'suspended',
        };

        $stmt = $pdo->prepare("UPDATE stores SET status = ? WHERE id = ?");
        $stmt->execute([$status, $storeId]);
    }

    header('Location: stores.php');
    exit;
}

// Get all stores
$stmt = $pdo->query("
    SELECT s.*, u.name as owner_name, u.email as owner_email
    FROM stores s
    JOIN users u ON s.user_id = u.id
    ORDER BY s.created_at DESC
");
$stores = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stores - Admin - ZITEO</title>
    <link rel="stylesheet" href="../app/assets/css/dashboard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        .admin-header {
            background: #1e293b;
            color: white;
            padding: 16px 24px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .admin-header .logo {
            color: #25D366;
            font-size: 1.5rem;
            font-weight: 700;
            text-decoration: none;
        }

        .admin-nav {
            display: flex;
            gap: 24px;
        }

        .admin-nav a {
            color: #94a3b8;
            text-decoration: none;
        }

        .admin-nav a:hover,
        .admin-nav a.active {
            color: white;
        }

        .admin-content {
            padding: 24px;
            max-width: 1200px;
            margin: 0 auto;
        }

        .stores-table {
            width: 100%;
            background: white;
            border-radius: 12px;
            overflow: hidden;
        }

        .stores-table th,
        .stores-table td {
            padding: 16px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }

        .stores-table th {
            background: #f8fafc;
            font-weight: 600;
        }

        .action-btn {
            padding: 6px 12px;
            border-radius: 6px;
            border: none;
            cursor: pointer;
            font-weight: 500;
            margin-right: 8px;
        }

        .action-btn.approve {
            background: #22c55e;
            color: white;
        }

        .action-btn.suspend {
            background: #f59e0b;
            color: white;
        }
    </style>
</head>

<body>
    <header class="admin-header">
        <a href="index.php" class="logo">ZITEO Admin</a>
        <nav class="admin-nav">
            <a href="index.php">Dashboard</a>
            <a href="stores.php" class="active">Stores</a>
            <a href="users.php">Users</a>
            <a href="logout.php">Logout</a>
        </nav>
    </header>

    <main class="admin-content">
        <h1>All Stores</h1>

        <table class="stores-table" style="margin-top: 24px;">
            <thead>
                <tr>
                    <th>Store</th>
                    <th>Owner</th>
                    <th>Products</th>
                    <th>Status</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($stores as $store): ?>
                    <?php
                    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM products WHERE store_id = ?");
                    $stmt->execute([$store['id']]);
                    $productCount = $stmt->fetch()['count'];
                    ?>
                    <tr>
                        <td>
                            <strong><?= e($store['name']) ?></strong><br>
                            <small><a href="https://<?= e($store['slug']) ?>.my.ziteo.in" target="_blank"><?= e($store['slug']) ?>.my.ziteo.in</a></small>
                        </td>
                        <td><?= e($store['owner_name']) ?><br><small><?= e($store['owner_email']) ?></small></td>
                        <td><?= $productCount ?></td>
                        <td><span class="status-badge status-<?= $store['status'] ?>"><?= ucfirst($store['status']) ?></span></td>
                        <td><?= date('d M Y', strtotime($store['created_at'])) ?></td>
                        <td>
                            <form method="POST" style="display: inline;">
                                <input type="hidden" name="store_id" value="<?= $store['id'] ?>">
                                <?php if ($store['status'] !== 'active'): ?>
                                    <button type="submit" name="action" value="approve" class="action-btn approve">Activate</button>
                                <?php endif; ?>
                                <?php if ($store['status'] !== 'suspended'): ?>
                                    <button type="submit" name="action" value="suspend" class="action-btn suspend">Suspend</button>
                                <?php endif; ?>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </main>
</body>

</html>