<?php

/**
 * Admin Panel - Users Management
 */
session_start();
require_once dirname(__DIR__, 2) . '/includes/auth.php';
requireAdmin();

$pdo = db();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = (int)($_POST['user_id'] ?? 0);
    $action = $_POST['action'] ?? '';

    if ($userId && in_array($action, ['activate', 'suspend'])) {
        $status = $action === 'activate' ? 'active' : 'suspended';
        $stmt = $pdo->prepare("UPDATE users SET status = ? WHERE id = ?");
        $stmt->execute([$status, $userId]);
    }

    header('Location: users.php');
    exit;
}

// Get all users
$stmt = $pdo->query("
    SELECT u.*, 
           (SELECT COUNT(*) FROM stores WHERE user_id = u.id) as store_count
    FROM users u
    ORDER BY u.created_at DESC
");
$users = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Users - Admin - ZITEO</title>
    <link rel="stylesheet" href="../app/assets/css/dashboard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        .admin-header {
            background: #1e293b;
            color: white;
            padding: 16px 24px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .admin-header .logo {
            color: #25D366;
            font-size: 1.5rem;
            font-weight: 700;
            text-decoration: none;
        }

        .admin-nav {
            display: flex;
            gap: 24px;
        }

        .admin-nav a {
            color: #94a3b8;
            text-decoration: none;
        }

        .admin-nav a:hover,
        .admin-nav a.active {
            color: white;
        }

        .admin-content {
            padding: 24px;
            max-width: 1200px;
            margin: 0 auto;
        }

        .users-table {
            width: 100%;
            background: white;
            border-radius: 12px;
            overflow: hidden;
        }

        .users-table th,
        .users-table td {
            padding: 16px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }

        .users-table th {
            background: #f8fafc;
            font-weight: 600;
        }

        .action-btn {
            padding: 6px 12px;
            border-radius: 6px;
            border: none;
            cursor: pointer;
            font-weight: 500;
        }

        .action-btn.activate {
            background: #22c55e;
            color: white;
        }

        .action-btn.suspend {
            background: #f59e0b;
            color: white;
        }
    </style>
</head>

<body>
    <header class="admin-header">
        <a href="index.php" class="logo">ZITEO Admin</a>
        <nav class="admin-nav">
            <a href="index.php">Dashboard</a>
            <a href="stores.php">Stores</a>
            <a href="users.php" class="active">Users</a>
            <a href="logout.php">Logout</a>
        </nav>
    </header>

    <main class="admin-content">
        <h1>All Users</h1>

        <table class="users-table" style="margin-top: 24px;">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Stores</th>
                    <th>Status</th>
                    <th>Joined</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td><strong><?= e($user['name']) ?></strong></td>
                        <td><?= e($user['email']) ?></td>
                        <td><?= e($user['phone'] ?: '-') ?></td>
                        <td><?= $user['store_count'] ?></td>
                        <td><span class="status-badge status-<?= $user['status'] ?>"><?= ucfirst($user['status']) ?></span></td>
                        <td><?= date('d M Y', strtotime($user['created_at'])) ?></td>
                        <td>
                            <form method="POST" style="display: inline;">
                                <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                                <?php if ($user['status'] === 'suspended'): ?>
                                    <button type="submit" name="action" value="activate" class="action-btn activate">Activate</button>
                                <?php else: ?>
                                    <button type="submit" name="action" value="suspend" class="action-btn suspend">Suspend</button>
                                <?php endif; ?>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </main>
</body>

</html>