<?php

/**
 * Create Store Page
 */
session_start();
require_once dirname(__DIR__, 2) . '/includes/auth.php';
requireAuth();

$pdo = db();

// Check if user already has a store
$stmt = $pdo->prepare("SELECT id FROM stores WHERE user_id = ?");
$stmt->execute([currentUserId()]);
if ($stmt->fetch()) {
    header('Location: dashboard.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $whatsapp = preg_replace('/[^0-9]/', '', $_POST['whatsapp'] ?? '');
    $slug = slugify($_POST['slug'] ?? $name);

    if (empty($name) || strlen($name) < 3) {
        $error = 'Store name must be at least 3 characters';
    } elseif (empty($whatsapp) || !isValidPhone($whatsapp)) {
        $error = 'Please enter a valid WhatsApp number';
    } else {
        // Check slug uniqueness
        $stmt = $pdo->prepare("SELECT id FROM stores WHERE slug = ?");
        $stmt->execute([$slug]);
        if ($stmt->fetch()) {
            $slug = $slug . '-' . rand(100, 999);
        }

        // Create store
        $stmt = $pdo->prepare("
            INSERT INTO stores (user_id, plan_id, name, slug, whatsapp, status, theme_config, created_at)
            VALUES (?, 1, ?, ?, ?, 'pending', '{}', NOW())
        ");
        $stmt->execute([currentUserId(), $name, $slug, $whatsapp]);

        $_SESSION['store_id'] = $pdo->lastInsertId();
        header('Location: dashboard.php');
        exit;
    }
}

include 'includes/header.php';
?>

<div class="dashboard-content">
    <div class="create-store-container">
        <h1>Create Your Store</h1>
        <p class="subtitle">Fill in the details below to set up your store.</p>

        <?php if ($error): ?>
            <div class="alert alert-error"><?= e($error) ?></div>
        <?php endif; ?>

        <form method="POST" class="store-form">
            <div class="form-group">
                <label for="name">Store Name *</label>
                <input type="text" id="name" name="name" required
                    value="<?= e($_POST['name'] ?? '') ?>"
                    placeholder="Riya's Fashion Hub">
                <small>This will be displayed to your customers</small>
            </div>

            <div class="form-group">
                <label for="slug">Store URL *</label>
                <div class="input-group">
                    <input type="text" id="slug" name="slug"
                        value="<?= e($_POST['slug'] ?? '') ?>"
                        placeholder="riyas-fashion-hub">
                    <span class="input-suffix">.my.ziteo.in</span>
                </div>
                <small>Only lowercase letters, numbers, and hyphens</small>
            </div>

            <div class="form-group">
                <label for="whatsapp">WhatsApp Number *</label>
                <div class="input-group">
                    <span class="input-prefix">+91</span>
                    <input type="tel" id="whatsapp" name="whatsapp" required
                        value="<?= e($_POST['whatsapp'] ?? '') ?>"
                        placeholder="9876543210">
                </div>
                <small>Customers will contact you on this number</small>
            </div>

            <button type="submit" class="btn btn-primary btn-large">Create Store</button>
        </form>
    </div>
</div>

<script>
    // Auto-generate slug from name
    document.getElementById('name').addEventListener('input', function() {
        const slug = this.value.toLowerCase()
            .replace(/[^a-z0-9\s-]/g, '')
            .replace(/\s+/g, '-')
            .replace(/-+/g, '-');
        document.getElementById('slug').value = slug;
    });
</script>

<?php include 'includes/footer.php'; ?>