<?php

/**
 * Store Owner Dashboard - Main Dashboard
 * app.ziteo.in/dashboard.php
 */
session_start();
require_once dirname(__DIR__, 2) . '/includes/auth.php';
requireAuth();

$user = getCurrentUser();

// If user not found in database, force logout
if (!$user) {
    logoutUser();
    header('Location: login.php');
    exit;
}

$pdo = db();

// Get user's store
$stmt = $pdo->prepare("SELECT * FROM stores WHERE user_id = ?");
$stmt->execute([currentUserId()]);
$store = $stmt->fetch();

// Get stats if store exists
$stats = ['products' => 0, 'orders' => 0, 'orders_week' => 0];
if ($store) {
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM products WHERE store_id = ?");
    $stmt->execute([$store['id']]);
    $stats['products'] = $stmt->fetch()['count'];

    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM orders WHERE store_id = ?");
    $stmt->execute([$store['id']]);
    $stats['orders'] = $stmt->fetch()['count'];

    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM orders WHERE store_id = ? AND created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
    $stmt->execute([$store['id']]);
    $stats['orders_week'] = $stmt->fetch()['count'];
}

include 'includes/header.php';
?>

<div class="dashboard-content">
    <?php if (!$store): ?>
        <!-- No Store - Empty State -->
        <div class="empty-state">
            <div class="empty-state-icon">🏪</div>
            <h2>Welcome, <?= e($user['name']) ?>!</h2>
            <p>Let's create your first store and start selling.</p>
            <a href="create-store.php" class="btn btn-primary btn-large">Create Your Store →</a>
        </div>
    <?php elseif ($store['status'] === 'pending'): ?>
        <!-- Store Pending -->
        <div class="empty-state">
            <div class="empty-state-icon">⏳</div>
            <h2>Store Under Review</h2>
            <p>Your store <strong><?= e($store['name']) ?></strong> is being reviewed.<br>This usually takes 24-48 hours.</p>
        </div>
    <?php else: ?>
        <!-- Active Store Dashboard -->
        <div class="dashboard-header">
            <div>
                <h1>Dashboard</h1>
                <p class="store-link">
                    <a href="https://<?= e($store['slug']) ?>.my.ziteo.in" target="_blank">
                        <?= e($store['slug']) ?>.my.ziteo.in
                    </a>
                    <button onclick="copyLink()" class="btn-copy" title="Copy link">📋</button>
                </p>
            </div>
        </div>

        <!-- Stats -->
        <div class="stats-grid">
            <div class="stat-card">
                <span class="stat-value"><?= $stats['products'] ?></span>
                <span class="stat-label">Products</span>
            </div>
            <div class="stat-card">
                <span class="stat-value"><?= $stats['orders_week'] ?></span>
                <span class="stat-label">Orders This Week</span>
            </div>
            <div class="stat-card">
                <span class="stat-value"><?= $stats['orders'] ?></span>
                <span class="stat-label">Total Orders</span>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions">
            <h3>Quick Actions</h3>
            <div class="action-grid">
                <a href="products.php?action=add" class="action-card">
                    <span class="action-icon">➕</span>
                    <span>Add Product</span>
                </a>
                <a href="products.php" class="action-card">
                    <span class="action-icon">📦</span>
                    <span>Manage Products</span>
                </a>
                <a href="orders.php" class="action-card">
                    <span class="action-icon">📋</span>
                    <span>View Orders</span>
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
    function copyLink() {
        navigator.clipboard.writeText('https://<?= e($store['slug'] ?? '') ?>.my.ziteo.in');
        alert('Link copied!');
    }
</script>

<?php include 'includes/footer.php'; ?>