<?php

/**
 * ZITEO API Entry Point
 * api.ziteo.in
 */

// CORS Headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Bootstrap
require_once dirname(__DIR__, 2) . '/includes/db.php';
require_once dirname(__DIR__, 2) . '/includes/functions.php';
require_once dirname(__DIR__, 2) . '/includes/auth.php';

// Start session
session_start();

// Simple Router
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = trim(str_replace('/api', '', $uri), '/');
$method = $_SERVER['REQUEST_METHOD'];

// Route mapping
$routes = [
    'GET' => [
        '' => fn() => jsonSuccess([], 'ZITEO API v1'),
        'stores/info' => 'v1/stores.php@getStoreBySlug',
        'products' => 'v1/products.php@getProducts',
        'products/(\d+)' => 'v1/products.php@getProduct',
    ],
    'POST' => [
        'auth/register' => 'v1/auth.php@register',
        'auth/login' => 'v1/auth.php@login',
        'auth/logout' => 'v1/auth.php@logout',
        'stores' => 'v1/stores.php@createStore',
        'products' => 'v1/products.php@createProduct',
        'orders/initiate' => 'v1/orders.php@initiateOrder',
    ],
    'PUT' => [
        'products/(\d+)' => 'v1/products.php@updateProduct',
        'orders/(\d+)/status' => 'v1/orders.php@updateStatus',
    ],
    'DELETE' => [
        'products/(\d+)' => 'v1/products.php@deleteProduct',
    ],
];

// Match route
$matched = false;
if (isset($routes[$method])) {
    foreach ($routes[$method] as $pattern => $handler) {
        $regex = '#^' . preg_replace('#\(\\\d\+\)#', '(\d+)', $pattern) . '$#';
        if (preg_match($regex, $uri, $matches)) {
            $matched = true;
            array_shift($matches); // Remove full match

            if (is_callable($handler)) {
                $handler();
            } else {
                list($file, $function) = explode('@', $handler);
                require_once __DIR__ . '/' . $file;
                call_user_func_array($function, $matches);
            }
            break;
        }
    }
}

if (!$matched) {
    jsonError('Endpoint not found', 404);
}
