<?php

/**
 * Orders API Endpoints
 */

function initiateOrder(): void
{
    $data = json_decode(file_get_contents('php://input'), true);

    $storeId = $data['store_id'] ?? null;
    $productId = $data['product_id'] ?? null;
    $productName = $data['product_name'] ?? '';
    $price = $data['price'] ?? 0;
    $quantity = $data['quantity'] ?? 1;

    if (!$storeId || !$productId) {
        jsonError('store_id and product_id are required');
    }

    $pdo = db();

    // Verify store exists
    $stmt = $pdo->prepare("SELECT id FROM stores WHERE id = ? AND status = 'active'");
    $stmt->execute([$storeId]);
    if (!$stmt->fetch()) {
        jsonError('Store not found', 404);
    }

    $orderNumber = generateOrderNumber();
    $items = json_encode([[
        'product_id' => $productId,
        'name' => $productName,
        'quantity' => $quantity,
        'price' => $price
    ]]);
    $total = $price * $quantity;

    $stmt = $pdo->prepare("
        INSERT INTO orders (store_id, order_number, items, total, status, created_at)
        VALUES (?, ?, ?, ?, 'initiated', NOW())
    ");
    $stmt->execute([$storeId, $orderNumber, $items, $total]);

    jsonSuccess([
        'order_id' => $pdo->lastInsertId(),
        'order_number' => $orderNumber
    ], 'Order initiated');
}

function updateStatus(int $orderId): void
{
    requireAuth();
    $storeId = currentStoreId();

    $data = json_decode(file_get_contents('php://input'), true);
    $status = $data['status'] ?? '';

    $validStatuses = ['initiated', 'confirmed', 'shipped', 'delivered', 'cancelled'];
    if (!in_array($status, $validStatuses)) {
        jsonError('Invalid status');
    }

    $pdo = db();
    $stmt = $pdo->prepare("UPDATE orders SET status = ? WHERE id = ? AND store_id = ?");
    $stmt->execute([$status, $orderId, $storeId]);

    if ($stmt->rowCount() === 0) {
        jsonError('Order not found', 404);
    }

    jsonSuccess([], 'Order status updated');
}
