<?php

/**
 * Dashboard Header Include
 */

// Get selected store for context-aware navigation
$selectedStoreId = getSelectedStoreId();
$selectedStore = null;
if ($selectedStoreId) {
    $selectedStore = validateStoreOwnership($selectedStoreId);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - ZITEO</title>
    <link rel="stylesheet" href="assets/css/dashboard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>
    <div class="dashboard-layout">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <a href="dashboard.php" class="logo">ZITEO</a>
            </div>
            <nav class="sidebar-nav">
                <?php if ($selectedStore): ?>
                    <!-- Store-specific navigation -->
                    <a href="dashboard.php" class="nav-item nav-back">
                        <span class="nav-icon">←</span>
                        All Stores
                    </a>
                    <div class="nav-store-header">
                        <span class="store-name"><?= e($selectedStore['name']) ?></span>
                    </div>
                    <a href="dashboard.php?store=<?= $selectedStore['id'] ?>" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'dashboard.php' && $selectedStoreId ? 'active' : '' ?>">
                        <span class="nav-icon">📊</span>
                        Overview
                    </a>
                    <a href="products.php?store=<?= $selectedStore['id'] ?>" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'products.php' ? 'active' : '' ?>">
                        <span class="nav-icon">📦</span>
                        Products
                    </a>
                    <a href="orders.php?store=<?= $selectedStore['id'] ?>" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'orders.php' ? 'active' : '' ?>">
                        <span class="nav-icon">📋</span>
                        Orders
                    </a>
                    <a href="settings.php?store=<?= $selectedStore['id'] ?>" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'settings.php' ? 'active' : '' ?>">
                        <span class="nav-icon">⚙️</span>
                        Store Settings
                    </a>
                    <a href="product-settings.php?store=<?= $selectedStore['id'] ?>" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'product-settings.php' ? 'active' : '' ?>">
                        <span class="nav-icon">🎛️</span>
                        Product Settings
                    </a>
                <?php else: ?>
                    <!-- Global navigation (no store selected) -->
                    <a href="dashboard.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'dashboard.php' ? 'active' : '' ?>">
                        <span class="nav-icon">🏪</span>
                        My Stores
                    </a>
                <?php endif; ?>

                <a href="select_plan.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) === 'select_plan.php' ? 'active' : '' ?>">
                    <span class="nav-icon">💎</span>
                    Upgrade Plan
                </a>
            </nav>
            <div class="sidebar-footer">
                <a href="logout.php" class="nav-item">
                    <span class="nav-icon">🚪</span>
                    Logout
                </a>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="main-content">