<?php

/**
 * Store Owner Dashboard - Register
 * app.ziteo.in/register.php
 */
session_start();
require_once dirname(__DIR__, 2) . '/includes/auth.php';

// Redirect if already logged in
if (isLoggedIn()) {
    header('Location: dashboard.php');
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';

    // Validation
    if (empty($name) || empty($email) || empty($password)) {
        $error = 'Please fill in all required fields';
    } elseif (strlen($password) < 6) {
        $error = 'Password must be at least 6 characters';
    } elseif ($password !== $confirmPassword) {
        $error = 'Passwords do not match';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email';
    } else {
        $result = registerUser($name, $email, $password, $phone);
        if ($result['success']) {
            header('Location: select_plan.php');
            exit;
        } else {
            $error = $result['error'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta content="width=device-width, initial-scale=1.0" name="viewport" />
    <title>Ziteo - Create Account</title>
    <script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        primary: "#128C7E", // WhatsApp Green-ish
                        "primary-hover": "#075E54",
                        "background-light": "#ffffff",
                        "background-dark": "#09090b",
                        "surface-light": "#f4f4f5",
                        "surface-dark": "#18181b",
                        "border-light": "#e4e4e7",
                        "border-dark": "#27272a",
                        "text-primary-light": "#18181b",
                        "text-primary-dark": "#ffffff",
                        "text-secondary-light": "#52525b",
                        "text-secondary-dark": "#a1a1aa",
                        "accent-indigo": "#6366f1",
                        "accent-rose": "#E1306C", // Instagram Pink-ish
                        "accent-blue": "#3b82f6"
                    },
                    fontFamily: {
                        sans: ['Plus Jakarta Sans', 'sans-serif'],
                        display: ['Plus Jakarta Sans', 'sans-serif'],
                        serif: ['Playfair Display', 'serif'],
                        mono: ['JetBrains Mono', 'monospace']
                    },
                    borderRadius: {
                        DEFAULT: "0.5rem",
                        'xl': '1rem',
                        '2xl': '1.5rem',
                        '3xl': '2rem',
                        '4xl': '2.5rem',
                    },
                    boxShadow: {
                        'soft': '0 4px 20px -2px rgba(0, 0, 0, 0.05)',
                        'card': '0 0 0 1px rgba(0,0,0,0.03), 0 2px 8px rgba(0,0,0,0.04)',
                        'glow': '0 0 40px -10px rgba(18, 140, 126, 0.3)',
                    },
                    backgroundImage: {
                        'grid-pattern': "url(\"data:image/svg+xml,%3Csvg width='40' height='40' viewBox='0 0 40 40' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='%239C92AC' fill-opacity='0.05' fill-rule='evenodd'%3E%3Cpath d='M0 40L40 0H20L0 20M40 40V20L20 40'/%3E%3C/g%3E%3C/svg%3E\")",
                        'dot-pattern': "radial-gradient(#e5e7eb 1px, transparent 1px)",
                        'dot-pattern-dark': "radial-gradient(#333 1px, transparent 1px)",
                    }
                },
            },
        };
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&amp;family=Playfair+Display:ital,wght@1,400&amp;family=JetBrains+Mono:wght@400&amp;display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap" rel="stylesheet" />
    <style>
        .font-serif-italic {
            font-family: 'Playfair Display', serif;
            font-style: italic;
        }

        .hero-pattern {
            background-image: linear-gradient(to right, rgba(0, 0, 0, 0.05) 1px, transparent 1px),
                linear-gradient(to bottom, rgba(0, 0, 0, 0.05) 1px, transparent 1px);
            background-size: 64px 64px;
        }

        .dark .hero-pattern {
            background-image: linear-gradient(to right, rgba(255, 255, 255, 0.05) 1px, transparent 1px),
                linear-gradient(to bottom, rgba(255, 255, 255, 0.05) 1px, transparent 1px);
        }

        .glass-card {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.5);
        }

        .dark .glass-card {
            background: rgba(24, 24, 27, 0.7);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
    </style>
</head>

<body class="bg-background-light dark:bg-background-dark text-text-primary-light dark:text-text-primary-dark font-sans antialiased selection:bg-primary selection:text-white transition-colors duration-300 overflow-hidden h-screen flex flex-col">
    <header class="fixed top-0 left-0 right-0 z-50 flex justify-center w-full pt-6 px-4">
        <nav class="w-full max-w-6xl glass-card rounded-full shadow-soft px-6 py-3.5 flex items-center justify-between transition-all duration-300">
            <a class="flex items-center gap-3" href="../index.php">
                <div class="bg-gradient-to-br from-primary to-emerald-600 text-white w-8 h-8 rounded-lg flex items-center justify-center font-bold text-lg shadow-sm">Z</div>
                <span class="font-display font-bold text-xl tracking-tight">ziteo</span>
            </a>
            <div class="flex items-center gap-3">
                <span class="text-sm text-text-secondary-light dark:text-text-secondary-dark hidden sm:block">Already have an account?</span>
                <a class="bg-surface-light hover:bg-surface-light/80 dark:bg-white/10 dark:hover:bg-white/20 text-text-primary-light dark:text-text-primary-dark text-sm font-semibold px-5 py-2.5 rounded-full transition-all border border-border-light dark:border-white/10" href="login.php">Log in</a>
            </div>
        </nav>
    </header>
    <main class="flex-grow flex items-center justify-center relative w-full h-full px-4 pt-20">
        <div class="absolute inset-0 hero-pattern opacity-60 pointer-events-none -z-10 [mask-image:radial-gradient(ellipse_at_center,black_40%,transparent_70%)]"></div>
        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[80vw] h-[600px] bg-gradient-to-r from-emerald-500/10 via-teal-500/10 to-green-500/10 blur-[120px] rounded-full pointer-events-none -z-20 opacity-70"></div>
        <div class="w-full max-w-md mx-auto relative z-10">
            <div class="bg-white dark:bg-surface-dark/60 backdrop-blur-xl border border-white/50 dark:border-white/10 rounded-3xl p-8 md:p-10 shadow-2xl relative overflow-hidden">
                <div class="absolute top-0 right-0 w-32 h-32 bg-primary/10 rounded-full blur-3xl -mr-16 -mt-16 pointer-events-none"></div>
                <div class="absolute bottom-0 left-0 w-32 h-32 bg-accent-rose/10 rounded-full blur-3xl -ml-16 -mb-16 pointer-events-none"></div>
                <div class="relative z-10">
                    <div class="text-center mb-8">
                        <h1 class="text-3xl font-display font-bold text-text-primary-light dark:text-text-primary-dark mb-2">Create Account</h1>
                        <p class="text-text-secondary-light dark:text-text-secondary-dark">Start selling in 30 seconds</p>
                    </div>
                    <?php if ($error): ?>
                        <div class="bg-red-50 text-red-500 text-sm p-3 rounded-lg mb-6 border border-red-100 text-center">
                            <?= e($error) ?>
                        </div>
                    <?php endif; ?>
                    <form class="space-y-5" method="POST">
                        <div>
                            <label class="block text-sm font-medium text-text-secondary-light dark:text-text-secondary-dark mb-1.5" for="name">Full Name</label>
                            <div class="relative">
                                <input class="block w-full rounded-xl border-gray-200 dark:border-gray-700 dark:bg-black/30 bg-gray-50 text-text-primary-light dark:text-text-primary-dark shadow-sm focus:border-primary focus:ring-primary sm:text-sm py-3 px-4 pl-10 transition-colors" id="name" name="name" placeholder="Riya Sharma" type="text" value="<?= e($_POST['name'] ?? '') ?>" required />
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400 text-[20px]">person</span>
                                </div>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-text-secondary-light dark:text-text-secondary-dark mb-1.5" for="email">Email</label>
                            <div class="relative">
                                <input class="block w-full rounded-xl border-gray-200 dark:border-gray-700 dark:bg-black/30 bg-gray-50 text-text-primary-light dark:text-text-primary-dark shadow-sm focus:border-primary focus:ring-primary sm:text-sm py-3 px-4 pl-10 transition-colors" id="email" name="email" placeholder="you@example.com" type="email" value="<?= e($_POST['email'] ?? '') ?>" required />
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400 text-[20px]">mail</span>
                                </div>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-text-secondary-light dark:text-text-secondary-dark mb-1.5" for="phone">Phone (Optional)</label>
                            <div class="relative">
                                <input class="block w-full rounded-xl border-gray-200 dark:border-gray-700 dark:bg-black/30 bg-gray-50 text-text-primary-light dark:text-text-primary-dark shadow-sm focus:border-primary focus:ring-primary sm:text-sm py-3 px-4 pl-10 transition-colors" id="phone" name="phone" placeholder="9876543210" type="tel" value="<?= e($_POST['phone'] ?? '') ?>" />
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400 text-[20px]">call</span>
                                </div>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-text-secondary-light dark:text-text-secondary-dark mb-1.5" for="password">Password</label>
                            <div class="relative">
                                <input class="block w-full rounded-xl border-gray-200 dark:border-gray-700 dark:bg-black/30 bg-gray-50 text-text-primary-light dark:text-text-primary-dark shadow-sm focus:border-primary focus:ring-primary sm:text-sm py-3 px-4 pl-10 transition-colors" id="password" name="password" placeholder="Min 6 characters" type="password" required />
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400 text-[20px]">lock</span>
                                </div>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-text-secondary-light dark:text-text-secondary-dark mb-1.5" for="confirm_password">Confirm Password</label>
                            <div class="relative">
                                <input class="block w-full rounded-xl border-gray-200 dark:border-gray-700 dark:bg-black/30 bg-gray-50 text-text-primary-light dark:text-text-primary-dark shadow-sm focus:border-primary focus:ring-primary sm:text-sm py-3 px-4 pl-10 transition-colors" id="confirm_password" name="confirm_password" placeholder="••••••••" type="password" required />
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400 text-[20px]">lock</span>
                                </div>
                            </div>
                        </div>
                        <div>
                            <button class="w-full flex justify-center items-center py-3.5 px-4 border border-transparent rounded-xl shadow-lg shadow-primary/20 text-sm font-semibold text-white bg-primary hover:bg-primary-hover dark:bg-white dark:text-black dark:hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary transition-all transform active:scale-[0.98]" type="submit">
                                Create Account
                                <span class="material-symbols-outlined ml-2 text-sm">arrow_forward</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="mt-8 text-center text-xs text-text-secondary-light dark:text-text-secondary-dark/60">
                <p>© 2024 Ziteo Inc. All rights reserved.</p>
                <div class="flex justify-center gap-4 mt-2">
                    <a class="hover:text-primary dark:hover:text-white transition-colors" href="#">Privacy</a>
                    <span class="text-gray-300 dark:text-gray-700">•</span>
                    <a class="hover:text-primary dark:hover:text-white transition-colors" href="#">Terms</a>
                    <span class="text-gray-300 dark:text-gray-700">•</span>
                    <a class="hover:text-primary dark:hover:text-white transition-colors" href="#">Help</a>
                </div>
            </div>
        </div>
    </main>
</body>

</html>