<?php

/**
 * Settings Page
 */
session_start();
require_once dirname(__DIR__, 2) . '/includes/auth.php';
requireAuth();

// Get store from URL parameter
$storeId = getSelectedStoreId();
if (!$storeId) {
    header('Location: dashboard.php');
    exit;
}

// Validate store ownership
$store = validateStoreOwnership($storeId);
if (!$store) {
    header('Location: dashboard.php');
    exit;
}

$pdo = db();

include 'includes/header.php';
?>

<div class="dashboard-content">
    <div class="page-header">
        <h1>Store Settings</h1>
    </div>

    <div class="settings-section">
        <h3>Store Information</h3>
        <div class="info-grid">
            <div class="info-item">
                <label>Store Name</label>
                <p><?= e($store['name']) ?></p>
            </div>
            <div class="info-item">
                <label>Store URL</label>
                <p><a href="https://<?= e($store['slug']) ?>.my.ziteo.in" target="_blank"><?= e($store['slug']) ?>.my.ziteo.in</a></p>
            </div>
            <div class="info-item">
                <label>WhatsApp</label>
                <p>+91 <?= e($store['whatsapp']) ?></p>
            </div>
            <div class="info-item">
                <label>Status</label>
                <p><span class="status-badge status-<?= $store['status'] ?>"><?= ucfirst($store['status']) ?></span></p>
            </div>
        </div>
    </div>

    <div class="settings-section">
        <h3>Account</h3>
        <p>More settings coming soon...</p>
    </div>
</div>

<?php include 'includes/footer.php'; ?>