<?php

/**
 * Wizard Step 2: Business Category Selection
 * User selects their store category from visual cards
 */

$error = '';
$data = $_SESSION['wizard_data'];

// Get categories from database
$categories = $pdo->query("SELECT * FROM business_categories ORDER BY display_order")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $categoryId = (int)($_POST['category_id'] ?? 0);

    // Validate category exists
    $stmt = $pdo->prepare("SELECT name FROM business_categories WHERE id = ?");
    $stmt->execute([$categoryId]);
    $category = $stmt->fetch();

    if (!$category) {
        $error = 'Please select a business category';
    } else {
        $_SESSION['wizard_data']['category_id'] = $categoryId;
        $_SESSION['wizard_data']['category_name'] = $category['name'];
        $_SESSION['wizard_data']['step'] = 3;

        header('Location: wizard.php?step=3');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Select Category - ZITEO</title>
    <link rel="stylesheet" href="../assets/css/dashboard.css">
    <link rel="stylesheet" href="../assets/css/wizard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>
    <div class="wizard-container">
        <!-- Progress Steps -->
        <div class="wizard-progress">
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Basics</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step active">
                <div class="step-number">2</div>
                <div class="step-label">Category</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">3</div>
                <div class="step-label">Product</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">4</div>
                <div class="step-label">Template</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">5</div>
                <div class="step-label">Publish</div>
            </div>
        </div>

        <!-- Step Content -->
        <div class="wizard-content">
            <div class="wizard-header">
                <h1>What do you sell?</h1>
                <p>Choose the category that best describes your business</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-error"><?= e($error) ?></div>
            <?php endif; ?>

            <form method="POST" class="wizard-form" id="categoryForm">
                <input type="hidden" name="category_id" id="categoryInput" value="<?= e($data['category_id'] ?? '') ?>">

                <div class="category-grid">
                    <?php foreach ($categories as $cat): ?>
                        <div class="category-card <?= ($data['category_id'] ?? 0) == $cat['id'] ? 'selected' : '' ?>"
                            data-id="<?= $cat['id'] ?>">
                            <span class="category-icon"><?= $cat['icon'] ?></span>
                            <span class="category-name"><?= e($cat['name']) ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="wizard-actions">
                    <a href="wizard.php?step=1" class="btn btn-outline">← Back</a>
                    <button type="submit" class="btn btn-primary btn-large">
                        Next →
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Category card selection
        document.querySelectorAll('.category-card').forEach(card => {
            card.addEventListener('click', function() {
                // Remove selection from all cards
                document.querySelectorAll('.category-card').forEach(c => c.classList.remove('selected'));
                // Select this card
                this.classList.add('selected');
                // Update hidden input
                document.getElementById('categoryInput').value = this.dataset.id;
            });
        });
    </script>
</body>

</html>