<?php

/**
 * Wizard Step 5: Review & Publish
 * Final review and store creation
 */

$error = '';
$data = $_SESSION['wizard_data'];

// Validate all required data exists
if (
    empty($data['store_name']) || empty($data['whatsapp']) ||
    empty($data['category_id']) || empty($data['product']) || empty($data['template_id'])
) {
    header('Location: wizard.php?step=1');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction();

        // 1. Create the store
        $stmt = $pdo->prepare("
            INSERT INTO stores (user_id, plan_id, name, slug, whatsapp, category, city, status, theme_config, created_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, 'active', ?, NOW())
        ");
        $stmt->execute([
            currentUserId(),
            getCurrentUser()['plan_id'],
            $data['store_name'],
            $data['slug'],
            $data['whatsapp'],
            $data['category_name'],
            $data['city'] ?: null,
            $data['theme_config']
        ]);

        $storeId = $pdo->lastInsertId();

        // 2. Move product image from temp to store folder if exists
        $productImage = null;
        if (!empty($data['product']['image'])) {
            $tempPath = UPLOAD_PATH . '/temp/' . $data['product']['image'];
            $storeDir = UPLOAD_PATH . '/' . $storeId;

            if (!is_dir($storeDir)) {
                mkdir($storeDir, 0755, true);
            }

            $newFilename = uniqid() . '.' . pathinfo($data['product']['image'], PATHINFO_EXTENSION);
            $newPath = $storeDir . '/' . $newFilename;

            if (file_exists($tempPath)) {
                rename($tempPath, $newPath);
                $productImage = $newFilename;
            }
        }

        // 3. Create the first product
        $stmt = $pdo->prepare("
            INSERT INTO products (store_id, name, description, price, image, stock_status, is_active, created_at)
            VALUES (?, ?, ?, ?, ?, 'in_stock', 1, NOW())
        ");
        $stmt->execute([
            $storeId,
            $data['product']['name'],
            $data['product']['description'] ?: null,
            $data['product']['price'] * 100, // Convert to paise
            $productImage
        ]);

        // 4. Update session with store ID
        $_SESSION['store_id'] = $storeId;

        // 5. Clear wizard data
        unset($_SESSION['wizard_data']);

        $pdo->commit();

        // Redirect to dashboard with success message
        flash('success', 'Congratulations! Your store "' . $data['store_name'] . '" is now live!');
        header('Location: ../dashboard.php');
        exit;
    } catch (Exception $e) {
        $pdo->rollBack();
        $error = 'Something went wrong. Please try again.';
        error_log('Wizard publish error: ' . $e->getMessage());
    }
}

// Get store URL
$storeUrl = $data['slug'] . '.my.ziteo.in';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Publish Your Store - ZITEO</title>
    <link rel="stylesheet" href="../assets/css/dashboard.css">
    <link rel="stylesheet" href="../assets/css/wizard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>
    <div class="wizard-container">
        <!-- Progress Steps -->
        <div class="wizard-progress">
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Basics</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Category</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Product</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Template</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step active">
                <div class="step-number">5</div>
                <div class="step-label">Publish</div>
            </div>
        </div>

        <!-- Step Content -->
        <div class="wizard-content">
            <div class="wizard-header">
                <h1>🎉 Ready to launch!</h1>
                <p>Review your store details and go live</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-error"><?= e($error) ?></div>
            <?php endif; ?>

            <div class="review-summary">
                <div class="review-section">
                    <h3>Store Details</h3>
                    <div class="review-grid">
                        <div class="review-item">
                            <span class="review-label">Store Name</span>
                            <span class="review-value"><?= e($data['store_name']) ?></span>
                        </div>
                        <div class="review-item">
                            <span class="review-label">WhatsApp</span>
                            <span class="review-value">+91 <?= e($data['whatsapp']) ?></span>
                        </div>
                        <div class="review-item">
                            <span class="review-label">Category</span>
                            <span class="review-value"><?= e($data['category_name'] ?? 'Not set') ?></span>
                        </div>
                        <?php if (!empty($data['city'])): ?>
                            <div class="review-item">
                                <span class="review-label">City</span>
                                <span class="review-value"><?= e($data['city']) ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="review-section">
                    <h3>Your Store URL</h3>
                    <div class="store-url-preview">
                        <span class="url-icon">🔗</span>
                        <span class="url-text"><?= e($storeUrl) ?></span>
                    </div>
                </div>

                <div class="review-section">
                    <h3>First Product</h3>
                    <div class="product-preview">
                        <div class="product-preview-image">
                            <?php if (!empty($data['product']['image'])): ?>
                                <img src="/uploads/temp/<?= e($data['product']['image']) ?>" alt="Product">
                            <?php else: ?>
                                <span class="no-image-icon">📦</span>
                            <?php endif; ?>
                        </div>
                        <div class="product-preview-info">
                            <h4><?= e($data['product']['name']) ?></h4>
                            <span class="product-preview-price">₹<?= number_format($data['product']['price']) ?></span>
                        </div>
                    </div>
                </div>

                <div class="review-section">
                    <h3>Template</h3>
                    <span class="template-badge"><?= e($data['template_name'] ?? 'Modern Minimal') ?></span>
                </div>
            </div>

            <form method="POST" class="wizard-form">
                <div class="wizard-actions publish-actions">
                    <a href="wizard.php?step=4" class="btn btn-outline">← Back</a>
                    <button type="submit" class="btn btn-primary btn-large btn-publish">
                        🚀 Publish My Store
                    </button>
                </div>
            </form>
        </div>
    </div>
</body>

</html>