<?php

/**
 * Store Creation Wizard - Main Controller
 * Routes to appropriate step based on wizard state
 */
session_start();
require_once dirname(__DIR__, 2) . '/includes/auth.php';
requireAuth();

$pdo = db();
$userId = currentUserId();

// Check if user already has a store
$stmt = $pdo->prepare("SELECT id FROM stores WHERE user_id = ? LIMIT 1");
$stmt->execute([$userId]);
if ($stmt->fetch()) {
    // User already has a store, redirect to dashboard
    header('Location: ../dashboard.php');
    exit;
}

// Check if user has a plan
$user = getCurrentUser();
if (empty($user['plan_id'])) {
    header('Location: ../select_plan.php?from=wizard');
    exit;
}

// Initialize wizard data if not exists
if (!isset($_SESSION['wizard_data'])) {
    $_SESSION['wizard_data'] = [
        'step' => 1,
        'store_name' => '',
        'whatsapp' => '',
        'city' => '',
        'slug' => '',
        'category_id' => null,
        'product' => null,
        'template_id' => null
    ];
}

// Get current step from session or URL
$currentStep = $_SESSION['wizard_data']['step'] ?? 1;
$requestedStep = isset($_GET['step']) ? (int)$_GET['step'] : $currentStep;

// Ensure user can only access completed steps + next step
if ($requestedStep > $currentStep) {
    $requestedStep = $currentStep;
}

// Clamp step between 1 and 5
$requestedStep = max(1, min(5, $requestedStep));

// Route to step file
switch ($requestedStep) {
    case 1:
        include 'step1-basics.php';
        break;
    case 2:
        include 'step2-category.php';
        break;
    case 3:
        include 'step3-product.php';
        break;
    case 4:
        include 'step4-template.php';
        break;
    case 5:
        include 'step5-publish.php';
        break;
    default:
        include 'step1-basics.php';
}
