<!DOCTYPE html>
<html lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>Ziteo - The Best Store Builder for WhatsApp & Instagram Sellers</title>
<meta content="Create your online store in minutes. Ziteo is the easiest website builder for WhatsApp and Instagram sellers. No coding required. Start selling today!" name="description"/>
<meta content="Ziteo - The Store Builder for WhatsApp & Instagram Sellers" property="og:title"/>
<meta content="Turn your followers into customers. The easiest way to launch an online store for your social media business." property="og:description"/>
<meta content="website" property="og:type"/>
<meta content="https://ziteo.store/" property="og:url"/>
<meta content="https://ziteo.store/og-image.jpg" property="og:image"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
<script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        primary: "#128C7E", // WhatsApp Green-ish
                        "primary-hover": "#075E54",
                        "background-light": "#ffffff",
                        "background-dark": "#09090b", 
                        "surface-light": "#f4f4f5",
                        "surface-dark": "#18181b",
                        "border-light": "#e4e4e7",
                        "border-dark": "#27272a",
                        "text-primary-light": "#18181b",
                        "text-primary-dark": "#ffffff",
                        "text-secondary-light": "#52525b",
                        "text-secondary-dark": "#a1a1aa",
                        "accent-indigo": "#6366f1",
                        "accent-rose": "#E1306C", // Instagram Pink-ish
                        "accent-blue": "#3b82f6"
                    },
                    fontFamily: {
                        sans: ['Plus Jakarta Sans', 'sans-serif'],
                        display: ['Plus Jakarta Sans', 'sans-serif'], // Simplified font stack
                        serif: ['Playfair Display', 'serif'],
                        mono: ['JetBrains Mono', 'monospace']
                    },
                    borderRadius: {
                        DEFAULT: "0.5rem",
                        'xl': '1rem',
                        '2xl': '1.5rem',
                        '3xl': '2rem',
                        '4xl': '2.5rem',
                    },
                    boxShadow: {
                        'soft': '0 4px 20px -2px rgba(0, 0, 0, 0.05)',
                        'card': '0 0 0 1px rgba(0,0,0,0.03), 0 2px 8px rgba(0,0,0,0.04)',
                        'glow': '0 0 40px -10px rgba(18, 140, 126, 0.3)',
                    }
                },
            },
        };
    </script>
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&amp;family=Playfair+Display:ital,wght@1,400&amp;family=JetBrains+Mono:wght@400&amp;display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap" rel="stylesheet"/>
<style>
        .font-serif-italic {
            font-family: 'Playfair Display', serif;
            font-style: italic;
        }
        .hero-pattern {
            background-image: linear-gradient(to right, rgba(0,0,0,0.05) 1px, transparent 1px),
                              linear-gradient(to bottom, rgba(0,0,0,0.05) 1px, transparent 1px);
            background-size: 64px 64px;
        }
        .dark .hero-pattern {
            background-image: linear-gradient(to right, rgba(255,255,255,0.05) 1px, transparent 1px),
                              linear-gradient(to bottom, rgba(255,255,255,0.05) 1px, transparent 1px);
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.5);
        }
        .dark .glass-card {
            background: rgba(24, 24, 27, 0.7);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
            100% { transform: translateY(0px); }
        }
    </style>
</head>
<body class="bg-background-light dark:bg-background-dark text-text-primary-light dark:text-text-primary-dark font-sans antialiased selection:bg-primary selection:text-white transition-colors duration-300 overflow-x-hidden">
<header class="fixed top-0 left-0 right-0 z-50 flex justify-center w-full pt-4 md:pt-6 px-4">
<nav class="w-full max-w-6xl glass-card rounded-full shadow-soft px-4 md:px-6 py-3 flex items-center justify-between transition-all duration-300">
<div class="flex items-center gap-2 md:gap-3">
<div class="bg-gradient-to-br from-primary to-emerald-600 text-white w-8 h-8 rounded-lg flex items-center justify-center font-bold text-lg shadow-sm">Z</div>
<span class="font-display font-bold text-xl tracking-tight">ziteo</span>
</div>
<div class="hidden md:flex items-center gap-8 text-sm font-medium text-text-secondary-light dark:text-text-secondary-dark">
<a class="hover:text-primary dark:hover:text-white transition-colors" href="#how-it-works">How It Works</a>
<a class="hover:text-primary dark:hover:text-white transition-colors" href="#features">Features</a>
<a class="hover:text-primary dark:hover:text-white transition-colors" href="#pricing">Pricing</a>
<a class="hover:text-primary dark:hover:text-white transition-colors" href="#demo">Demo Store</a>
</div>
<div class="flex items-center gap-3">
<a class="hidden sm:block text-sm font-medium px-4 py-2 text-text-primary-light dark:text-text-primary-dark hover:bg-surface-light dark:hover:bg-white/10 rounded-full transition-colors" href="app/login.php">Log in</a>
<a class="bg-primary hover:bg-primary-hover text-white text-sm font-semibold px-5 py-2.5 rounded-full transition-all shadow-lg shadow-primary/20 hover:scale-105" href="app/register.php">Create Store</a>
<button aria-label="Menu" class="md:hidden p-2 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-full transition-colors text-text-primary-light dark:text-text-primary-dark ml-1">
<span class="material-symbols-outlined">menu</span>
</button>
</div>
</nav>
</header>
<main class="w-full overflow-hidden">
<section class="pt-32 pb-16 md:pt-48 md:pb-32 px-4 relative">
<div class="absolute inset-0 hero-pattern opacity-60 pointer-events-none -z-10 [mask-image:radial-gradient(ellipse_at_center,black_40%,transparent_70%)]"></div>
<div class="absolute top-0 left-1/2 -translate-x-1/2 w-[80vw] h-[600px] bg-gradient-to-r from-emerald-500/10 via-teal-500/10 to-green-500/10 blur-[120px] rounded-full pointer-events-none -z-20 opacity-70"></div>
<div class="max-w-7xl mx-auto flex flex-col items-center text-center relative z-10">
<div class="inline-flex items-center gap-2 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-full px-4 py-1.5 text-xs font-medium mb-8 md:mb-10 shadow-sm">
<span class="flex h-2 w-2 relative">
<span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-500 opacity-75"></span>
<span class="relative inline-flex rounded-full h-2 w-2 bg-green-500"></span>
</span>
<span class="text-green-800 dark:text-green-300">Perfect for Instagram & WhatsApp Sellers</span>
</div>
<h1 class="text-4xl md:text-7xl lg:text-8xl font-display font-extrabold tracking-tight mb-6 md:mb-8 leading-[1.1] text-text-primary-light dark:text-text-primary-dark">
                    Turn your <span class="text-transparent bg-clip-text bg-gradient-to-r from-[#E1306C] to-[#C13584]">followers</span> <br class="hidden md:block"/>
                    into <span class="font-serif-italic font-normal relative z-10 inline-block text-primary px-1">
                        customers
                        <svg class="absolute w-full h-3 -bottom-1 left-0 text-primary/30 -z-10" preserveAspectRatio="none" viewBox="0 0 100 10">
<path d="M0 5 Q 50 10 100 5" fill="none" stroke="currentColor" stroke-width="8"></path>
</svg>
</span>.
                </h1>
<p class="text-lg md:text-xl text-text-secondary-light dark:text-text-secondary-dark mb-10 md:mb-12 leading-relaxed max-w-2xl mx-auto font-normal">
                    The easiest way to launch an online store for your WhatsApp and Instagram business. <br class="hidden sm:block"/> No coding required. Manage products and get orders directly on chat.
                </p>
<div class="flex flex-col sm:flex-row items-center justify-center gap-4 mb-16 md:mb-20 w-full max-w-md mx-auto">
<a class="w-full sm:w-auto bg-primary hover:bg-primary-hover text-white font-semibold py-4 px-10 rounded-full transition-all flex items-center justify-center gap-2 group shadow-xl shadow-primary/25 hover:shadow-2xl hover:-translate-y-1" href="app/register.php">
                        Create Store
                        <span class="material-symbols-outlined text-sm transition-transform group-hover:translate-x-1">storefront</span>
</a>
<a class="w-full sm:w-auto bg-white dark:bg-surface-dark border border-border-light dark:border-border-dark hover:bg-gray-50 dark:hover:bg-gray-800 text-text-primary-light dark:text-text-primary-dark font-medium py-4 px-10 rounded-full transition-all shadow-sm hover:shadow-md text-center" href="#demo">
                        View Demo Store
                    </a>
</div>
<div class="w-full max-w-5xl mx-auto relative group perspective-1000">
<div class="absolute -top-10 -left-10 w-40 h-40 bg-green-500/20 rounded-full blur-3xl animate-pulse"></div>
<div class="absolute -bottom-10 -right-10 w-40 h-40 bg-pink-500/20 rounded-full blur-3xl animate-pulse delay-700"></div>
<div class="relative rounded-2xl bg-white dark:bg-gray-900 border border-border-light dark:border-border-dark shadow-[0_30px_60px_-10px_rgba(0,0,0,0.12)] overflow-hidden transition-transform duration-700 hover:scale-[1.01]">
<div class="h-12 bg-white/80 dark:bg-gray-900/80 backdrop-blur-md border-b border-border-light dark:border-border-dark flex items-center px-6 justify-between z-20 sticky top-0">
<div class="flex gap-2">
<div class="w-3 h-3 rounded-full bg-red-400"></div>
<div class="w-3 h-3 rounded-full bg-yellow-400"></div>
<div class="w-3 h-3 rounded-full bg-green-400"></div>
</div>
<div class="flex-1 max-w-lg mx-4">
<div class="bg-gray-100 dark:bg-gray-800 rounded-md h-7 w-full flex items-center px-3 text-xs text-gray-400 font-mono justify-center">
<span class="material-symbols-outlined text-[14px] mr-2">lock</span> ziteo.store/your-brand
                                </div>
</div>
</div>
<div class="w-full aspect-[16/9] md:aspect-[21/9] bg-gray-50 dark:bg-black relative flex overflow-hidden">
<div class="w-64 border-r border-border-light dark:border-border-dark bg-white dark:bg-surface-dark/30 hidden md:flex flex-col p-4">
<div class="flex items-center gap-2 mb-8">
<div class="w-8 h-8 rounded-full bg-primary/20 flex items-center justify-center text-primary font-bold">B</div>
<span class="font-bold">Boutique Store</span>
</div>
<div class="space-y-1">
<div class="flex items-center gap-3 px-3 py-2 bg-primary/10 text-primary rounded-lg font-medium text-sm">
<span class="material-symbols-outlined text-lg">inventory_2</span> Products
                                    </div>
<div class="flex items-center gap-3 px-3 py-2 text-gray-500 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-lg font-medium text-sm">
<span class="material-symbols-outlined text-lg">shopping_cart</span> Orders <span class="ml-auto bg-red-500 text-white text-[10px] px-1.5 rounded-full">3</span>
</div>
<div class="flex items-center gap-3 px-3 py-2 text-gray-500 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-lg font-medium text-sm">
<span class="material-symbols-outlined text-lg">analytics</span> Analytics
                                    </div>
<div class="flex items-center gap-3 px-3 py-2 text-gray-500 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-lg font-medium text-sm">
<span class="material-symbols-outlined text-lg">settings</span> Settings
                                    </div>
</div>
</div>
<div class="flex-1 p-6 md:p-8 overflow-y-auto">
<div class="flex justify-between items-center mb-6">
<h2 class="text-xl font-bold">Products</h2>
<button class="bg-primary text-white text-sm px-4 py-2 rounded-lg flex items-center gap-2">
<span class="material-symbols-outlined text-sm">add</span> Add New
                                    </button>
</div>
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
<div class="bg-white dark:bg-gray-900 rounded-xl p-3 border border-gray-100 dark:border-gray-800 shadow-sm flex gap-4 items-center">
<div class="w-16 h-16 bg-gray-100 rounded-lg flex items-center justify-center shrink-0">
<span class="material-symbols-outlined text-gray-400">checkroom</span>
</div>
<div class="flex-1 min-w-0">
<h3 class="font-medium text-sm truncate">Summer Floral Dress</h3>
<p class="text-primary font-bold text-sm">₹1,499</p>
</div>
<div class="text-green-500 text-xs bg-green-50 dark:bg-green-900/30 px-2 py-1 rounded-full">Active</div>
</div>
<div class="bg-white dark:bg-gray-900 rounded-xl p-3 border border-gray-100 dark:border-gray-800 shadow-sm flex gap-4 items-center">
<div class="w-16 h-16 bg-gray-100 rounded-lg flex items-center justify-center shrink-0">
<span class="material-symbols-outlined text-gray-400">styler</span>
</div>
<div class="flex-1 min-w-0">
<h3 class="font-medium text-sm truncate">Denim Jacket</h3>
<p class="text-primary font-bold text-sm">₹2,299</p>
</div>
<div class="text-green-500 text-xs bg-green-50 dark:bg-green-900/30 px-2 py-1 rounded-full">Active</div>
</div>
<div class="bg-white dark:bg-gray-900 rounded-xl p-3 border border-gray-100 dark:border-gray-800 shadow-sm flex gap-4 items-center">
<div class="w-16 h-16 bg-gray-100 rounded-lg flex items-center justify-center shrink-0">
<span class="material-symbols-outlined text-gray-400">shopping_bag</span>
</div>
<div class="flex-1 min-w-0">
<h3 class="font-medium text-sm truncate">Leather Tote Bag</h3>
<p class="text-primary font-bold text-sm">₹3,499</p>
</div>
<div class="text-green-500 text-xs bg-green-50 dark:bg-green-900/30 px-2 py-1 rounded-full">Active</div>
</div>
</div>
</div>
</div>
</div>
</div>
<div class="mt-16 md:mt-20 flex flex-col items-center gap-6">
<p class="text-sm font-medium text-text-secondary-light dark:text-text-secondary-dark uppercase tracking-widest">Trusted by 20,000+ social sellers</p>
<div class="flex items-center gap-2">
<div class="flex -space-x-3">
<img alt="User 1" class="w-10 h-10 rounded-full border-2 border-white dark:border-black object-cover" height="40" loading="lazy" src="https://lh3.googleusercontent.com/aida-public/AB6AXuABnixevhe8zIQ0RoYhKpvg8c32k-brGlFuub1nR2vCB6aFjNKypoK3y1vNfB7DubxxGmB5h93RhTsCZ5q1IPKu6kAa8N_IGWTILv-neK97uxMA68XltPmdi12kI8LeUXarHYxkx1uYGDvOSjaKNg5rtISpFIumU6s6zfPXvjx4WssTWE5UoGZ3QGlq9gFPUf8eHFGogsr9QCRt3dBzyFgzNW-AU_OxdxE0Ce86jl114AeGJ6YCLg2HQluCaA6haxnblIz15X6JicLc" width="40"/>
<img alt="User 2" class="w-10 h-10 rounded-full border-2 border-white dark:border-black object-cover" height="40" loading="lazy" src="https://lh3.googleusercontent.com/aida-public/AB6AXuBVQhoXrhp0v_2T7mOW3GnkdZW95W642udtLuqbb8hQ9VV5nvFjVRALyqB-pWnCLXgcoYh4hh9FGKWGwWrr9_MaWzKGEv-eMNu4Gq1-kL4JkBK6s_oS-1RCz2CO9W24wCwGAC7zKMvU1cKMW8X_zWMCrD4vcRMmDFaIRZJc8PRrkP3OcME-NOhtFogKTuqXde8INqZgMkwkJWmKOoyn0DHvkbdcre45Lvw1CD9H72xD9h4mCoLwktMXRwm56P_6Lk6LqsYSJjNouFeM" width="40"/>
<img alt="User 3" class="w-10 h-10 rounded-full border-2 border-white dark:border-black object-cover" height="40" loading="lazy" src="https://lh3.googleusercontent.com/aida-public/AB6AXuCkfXJ3WQubdUzfSc0irfOCdAnuG5VzZ3_UCZat6aga4vKEsKWcySYF_gRknuXbw4uvHHt5DhTw8LEb7mq8kesb-yzEE38K3jMjMP26GbPZ1RDCvnuGeeg0q7e1krGaqhNQKoVYRHhHYfYvqvwqdTb1-HD9GZ8ycqMyKBcDCklPbiZDtAfuNscPllF34xtGCWyCPJhCZCOsT_FZY60OA51-KlIbnz2HDO562TzpdnHa9Zb25o31achG72zpUt8dpzhf6tX9Vl0rwtdr" width="40"/>
<div class="w-10 h-10 rounded-full border-2 border-white dark:border-black bg-gray-100 dark:bg-gray-800 flex items-center justify-center text-xs font-bold text-gray-600 dark:text-gray-400">+2k</div>
</div>
<div class="flex flex-col ml-3 text-left">
<div class="flex text-yellow-400 text-sm">
<span class="material-symbols-outlined text-[16px] filled" style="font-variation-settings: 'FILL' 1">star</span>
<span class="material-symbols-outlined text-[16px] filled" style="font-variation-settings: 'FILL' 1">star</span>
<span class="material-symbols-outlined text-[16px] filled" style="font-variation-settings: 'FILL' 1">star</span>
<span class="material-symbols-outlined text-[16px] filled" style="font-variation-settings: 'FILL' 1">star</span>
<span class="material-symbols-outlined text-[16px] filled" style="font-variation-settings: 'FILL' 1">star</span>
</div>
<span class="text-xs text-text-secondary-light dark:text-text-secondary-dark font-medium">4.9/5 seller rating</span>
</div>
</div>
</div>
</div>
</section>
<section class="py-16 bg-surface-light dark:bg-surface-dark/30 border-y border-border-light dark:border-border-dark">
<div class="max-w-7xl mx-auto px-4 md:px-6">
<div class="text-center mb-12">
<h2 class="text-2xl md:text-3xl font-display font-bold mb-3">Who uses Ziteo?</h2>
<p class="text-text-secondary-light dark:text-text-secondary-dark">Perfect for anyone selling on social media</p>
</div>
<div class="grid grid-cols-1 xs:grid-cols-2 md:grid-cols-4 gap-6">
<div class="flex flex-col items-center text-center p-6 bg-white dark:bg-surface-dark rounded-2xl shadow-sm hover:shadow-md transition-all">
<div class="w-14 h-14 bg-pink-100 text-pink-600 rounded-full flex items-center justify-center mb-4">
<span class="material-symbols-outlined text-3xl">checkroom</span>
</div>
<h3 class="font-bold text-lg mb-1">Fashion Boutiques</h3>
<p class="text-sm text-gray-500">Clothing, accessories, and thrift stores.</p>
</div>
<div class="flex flex-col items-center text-center p-6 bg-white dark:bg-surface-dark rounded-2xl shadow-sm hover:shadow-md transition-all">
<div class="w-14 h-14 bg-orange-100 text-orange-600 rounded-full flex items-center justify-center mb-4">
<span class="material-symbols-outlined text-3xl">cookie</span>
</div>
<h3 class="font-bold text-lg mb-1">Home Bakers</h3>
<p class="text-sm text-gray-500">Cakes, cookies, and homemade treats.</p>
</div>
<div class="flex flex-col items-center text-center p-6 bg-white dark:bg-surface-dark rounded-2xl shadow-sm hover:shadow-md transition-all">
<div class="w-14 h-14 bg-purple-100 text-purple-600 rounded-full flex items-center justify-center mb-4">
<span class="material-symbols-outlined text-3xl">brush</span>
</div>
<h3 class="font-bold text-lg mb-1">Artists & Creators</h3>
<p class="text-sm text-gray-500">Digital art, prints, and handmade crafts.</p>
</div>
<div class="flex flex-col items-center text-center p-6 bg-white dark:bg-surface-dark rounded-2xl shadow-sm hover:shadow-md transition-all">
<div class="w-14 h-14 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mb-4">
<span class="material-symbols-outlined text-3xl">shopping_bag</span>
</div>
<h3 class="font-bold text-lg mb-1">Resellers</h3>
<p class="text-sm text-gray-500">Curated products and dropshipping.</p>
</div>
</div>
</div>
</section>
<section class="py-24 px-4 md:px-6 max-w-7xl mx-auto" id="how-it-works">
<div class="text-center max-w-3xl mx-auto mb-16">
<span class="text-primary font-bold tracking-wider uppercase text-sm mb-2 block">How It Works</span>
<h2 class="text-3xl md:text-4xl font-display font-bold mb-6">Sell in 3 simple steps</h2>
</div>
<div class="grid grid-cols-1 md:grid-cols-3 gap-8 relative">
<div class="absolute top-1/2 left-0 w-full h-1 border-t-2 border-dashed border-gray-200 dark:border-gray-800 hidden md:block -z-10"></div>
<div class="bg-white dark:bg-surface-dark p-8 rounded-2xl border border-gray-100 dark:border-gray-800 text-center relative">
<div class="w-12 h-12 bg-primary text-white rounded-full flex items-center justify-center text-xl font-bold mx-auto mb-6 shadow-lg shadow-primary/30">1</div>
<h3 class="text-xl font-bold mb-3">Create & Add Products</h3>
<p class="text-gray-500">Sign up and add your product photos, descriptions, and prices. Your store is ready instantly.</p>
</div>
<div class="bg-white dark:bg-surface-dark p-8 rounded-2xl border border-gray-100 dark:border-gray-800 text-center relative">
<div class="w-12 h-12 bg-primary text-white rounded-full flex items-center justify-center text-xl font-bold mx-auto mb-6 shadow-lg shadow-primary/30">2</div>
<h3 class="text-xl font-bold mb-3">Share on Social Media</h3>
<p class="text-gray-500">Put your store link in your Instagram bio, WhatsApp status, or share it directly with customers.</p>
</div>
<div class="bg-white dark:bg-surface-dark p-8 rounded-2xl border border-gray-100 dark:border-gray-800 text-center relative">
<div class="w-12 h-12 bg-primary text-white rounded-full flex items-center justify-center text-xl font-bold mx-auto mb-6 shadow-lg shadow-primary/30">3</div>
<h3 class="text-xl font-bold mb-3">Get Orders on WhatsApp</h3>
<p class="text-gray-500">Customers browse your store and checkout. You receive the order details instantly on WhatsApp.</p>
</div>
</div>
</section>
<section class="py-20 px-4 md:px-6 bg-surface-light/50 dark:bg-black/20" id="features">
<div class="max-w-7xl mx-auto">
<div class="text-center max-w-3xl mx-auto mb-20">
<h2 class="text-3xl md:text-5xl font-display font-bold mb-6">Everything you need to <span class="font-serif-italic font-normal">grow</span>.</h2>
<p class="text-lg text-text-secondary-light dark:text-text-secondary-dark">Powerful features designed for small businesses and solo entrepreneurs.</p>
</div>
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8">
<div class="md:col-span-2 bg-white dark:bg-surface-dark/50 rounded-3xl p-8 md:p-10 border border-border-light dark:border-border-dark hover:border-primary/30 transition-all duration-500 group overflow-hidden relative">
<div class="relative z-10 max-w-md">
<div class="w-14 h-14 bg-primary/10 text-primary rounded-2xl flex items-center justify-center mb-6 shadow-sm">
<span class="material-symbols-outlined text-2xl">store</span>
</div>
<h3 class="font-display font-semibold text-2xl mb-3">Instant Store Creation</h3>
<p class="text-text-secondary-light dark:text-text-secondary-dark leading-relaxed text-lg">
                                Get a professional-looking website without hiring a developer. Choose a theme, upload your logo, and you're live in minutes.
                            </p>
</div>
</div>
<div class="bg-white dark:bg-surface-dark/50 rounded-3xl p-8 md:p-10 border border-border-light dark:border-border-dark hover:border-primary/30 transition-all duration-300 group flex flex-col justify-between">
<div>
<div class="w-14 h-14 bg-green-100 text-green-600 rounded-2xl flex items-center justify-center mb-6 shadow-sm group-hover:scale-110 transition-transform duration-300">
<span class="material-symbols-outlined text-2xl">chat</span>
</div>
<h3 class="font-display font-semibold text-2xl mb-3">WhatsApp Orders</h3>
<p class="text-text-secondary-light dark:text-text-secondary-dark leading-relaxed">
                                Receive fully formatted orders directly to your WhatsApp number. No missed DMs, no confusion.
                            </p>
</div>
</div>
<div class="bg-white dark:bg-surface-dark/50 rounded-3xl p-8 md:p-10 border border-border-light dark:border-border-dark hover:border-primary/30 transition-all duration-300 group">
<div class="w-14 h-14 bg-purple-100 text-purple-600 rounded-2xl flex items-center justify-center mb-6 shadow-sm group-hover:rotate-12 transition-transform duration-300">
<span class="material-symbols-outlined text-2xl">inventory</span>
</div>
<h3 class="font-display font-semibold text-2xl mb-3">Product Management</h3>
<p class="text-text-secondary-light dark:text-text-secondary-dark leading-relaxed mb-4">
                            Manage inventory, variants (size, color), and prices easily.
                        </p>
<div class="flex flex-wrap gap-2">
<span class="bg-gray-100 dark:bg-gray-800 text-xs px-2 py-1 rounded">Size: S, M, L</span>
<span class="bg-gray-100 dark:bg-gray-800 text-xs px-2 py-1 rounded">Color: Red, Blue</span>
</div>
</div>
<div class="bg-white dark:bg-surface-dark/50 rounded-3xl p-8 md:p-10 border border-border-light dark:border-border-dark hover:border-primary/30 transition-all duration-300 group">
<div class="w-14 h-14 bg-pink-100 text-pink-600 rounded-2xl flex items-center justify-center mb-6 shadow-sm group-hover:rotate-12 transition-transform duration-300">
<span class="material-symbols-outlined text-2xl">favorite</span>
</div>
<h3 class="font-display font-semibold text-2xl mb-3">Wishlist & Accounts</h3>
<p class="text-text-secondary-light dark:text-text-secondary-dark leading-relaxed">
                            Let customers create accounts to save their favorite items and track their order history.
                        </p>
</div>
<div class="md:col-span-1 bg-white dark:bg-surface-dark/50 rounded-3xl p-8 md:p-10 border border-border-light dark:border-border-dark hover:border-primary/30 transition-all duration-300 group">
<div class="w-14 h-14 bg-blue-100 text-blue-600 rounded-2xl flex items-center justify-center mb-6 shadow-sm">
<span class="material-symbols-outlined text-2xl">language</span>
</div>
<h3 class="font-display font-semibold text-2xl mb-3">Custom Domains</h3>
<p class="text-text-secondary-light dark:text-text-secondary-dark leading-relaxed">
                            Connect your own domain (e.g., mystore.com) to build brand trust and improve SEO.
                        </p>
</div>
</div>
</div>
</section>
<section class="py-24 px-4 md:px-6 max-w-7xl mx-auto" id="pricing">
<div class="text-center mb-16">
<h2 class="text-3xl md:text-5xl font-display font-bold mb-6">Simple, Affordable Pricing</h2>
<p class="text-lg text-text-secondary-light dark:text-text-secondary-dark">Start small and scale as you grow. No hidden fees.</p>
</div>
<div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-6xl mx-auto items-center">
<div class="border border-border-light dark:border-border-dark rounded-2xl p-8 bg-white dark:bg-surface-dark hover:shadow-xl transition-shadow relative order-2 md:order-1">
<h3 class="text-xl font-bold mb-2">Starter</h3>
<p class="text-gray-500 text-sm mb-6">For new sellers just starting out.</p>
<div class="flex items-end gap-1 mb-8">
<span class="text-4xl font-bold">₹49</span>
<span class="text-gray-500 mb-1">/month</span>
</div>
<a class="block w-full text-center py-3 px-4 border border-primary text-primary hover:bg-primary hover:text-white rounded-xl font-semibold transition-colors mb-8" href="app/register.php">Get Started</a>
<ul class="space-y-4 text-sm">
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Up to 50 Products</li>
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> WhatsApp Order Receiving</li>
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Basic Store Analytics</li>
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-gray-400 text-lg">close</span> Custom Domain</li>
</ul>
</div>
<div class="border-2 border-primary rounded-2xl p-8 bg-surface-light dark:bg-surface-dark/80 shadow-2xl relative order-1 md:order-2 md:-translate-y-4">
<div class="absolute top-0 left-1/2 -translate-x-1/2 -translate-y-1/2 bg-primary text-white px-4 py-1 rounded-full text-xs font-bold uppercase tracking-wide">Most Popular</div>
<h3 class="text-xl font-bold mb-2">Pro</h3>
<p class="text-gray-500 text-sm mb-6">For growing businesses.</p>
<div class="flex items-end gap-1 mb-8">
<span class="text-4xl font-bold">₹99</span>
<span class="text-gray-500 mb-1">/month</span>
</div>
<a class="block w-full text-center py-3 px-4 bg-primary text-white hover:bg-primary-hover rounded-xl font-semibold transition-colors mb-8 shadow-lg shadow-primary/25" href="app/register.php">Get Started</a>
<ul class="space-y-4 text-sm">
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Unlimited Products</li>
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Customer Wishlist</li>
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Advanced Analytics</li>
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Priority Support</li>
</ul>
</div>
<div class="border border-border-light dark:border-border-dark rounded-2xl p-8 bg-white dark:bg-surface-dark hover:shadow-xl transition-shadow relative order-3">
<h3 class="text-xl font-bold mb-2">Business</h3>
<p class="text-gray-500 text-sm mb-6">For established brands.</p>
<div class="flex items-end gap-1 mb-8">
<span class="text-4xl font-bold">₹199</span>
<span class="text-gray-500 mb-1">/month</span>
</div>
<a class="block w-full text-center py-3 px-4 border border-primary text-primary hover:bg-primary hover:text-white rounded-xl font-semibold transition-colors mb-8" href="app/register.php">Get Started</a>
<ul class="space-y-4 text-sm">
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Everything in Pro</li>
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Custom Domain Connection</li>
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Removal of Ziteo Branding</li>
<li class="flex items-center gap-3"><span class="material-symbols-outlined text-green-500 text-lg">check</span> Dedicated Account Manager</li>
</ul>
</div>
</div>
</section>
<section class="py-20 px-4 md:px-6 bg-surface-light dark:bg-black/40">
<div class="max-w-4xl mx-auto">
<h2 class="text-3xl font-display font-bold mb-12 text-center">Frequently Asked Questions</h2>
<div class="space-y-4">
<details class="group bg-white dark:bg-surface-dark rounded-xl p-4 cursor-pointer border border-transparent hover:border-primary/20 transition-all">
<summary class="flex justify-between items-center font-medium list-none">
<span>Do I need a computer to use Ziteo?</span>
<span class="material-symbols-outlined transition-transform group-open:rotate-180">expand_more</span>
</summary>
<div class="text-gray-500 mt-3 text-sm leading-relaxed">
                            No! Ziteo is fully mobile-responsive. You can create, manage, and run your entire store directly from your smartphone.
                        </div>
</details>
<details class="group bg-white dark:bg-surface-dark rounded-xl p-4 cursor-pointer border border-transparent hover:border-primary/20 transition-all">
<summary class="flex justify-between items-center font-medium list-none">
<span>How do I receive payments?</span>
<span class="material-symbols-outlined transition-transform group-open:rotate-180">expand_more</span>
</summary>
<div class="text-gray-500 mt-3 text-sm leading-relaxed">
                            You can choose to accept payments via UPI, Cash on Delivery, or integrate payment gateways depending on your plan. Most sellers coordinate payment on WhatsApp after receiving the order.
                        </div>
</details>
<details class="group bg-white dark:bg-surface-dark rounded-xl p-4 cursor-pointer border border-transparent hover:border-primary/20 transition-all">
<summary class="flex justify-between items-center font-medium list-none">
<span>Can I use my own domain name?</span>
<span class="material-symbols-outlined transition-transform group-open:rotate-180">expand_more</span>
</summary>
<div class="text-gray-500 mt-3 text-sm leading-relaxed">
                            Yes, the Business plan (₹199/mo) allows you to connect your own custom domain (e.g., yourstore.com) for a professional look.
                        </div>
</details>
</div>
</div>
</section>
<section class="py-16 px-4 border-t border-border-light dark:border-border-dark">
<div class="max-w-7xl mx-auto flex flex-col md:flex-row justify-center items-center gap-12 text-center md:text-left opacity-70">
<div class="flex items-center gap-4">
<span class="material-symbols-outlined text-4xl text-gray-400">lock</span>
<div>
<h4 class="font-bold">Secure Platform</h4>
<p class="text-xs text-gray-500">Your data is encrypted and safe.</p>
</div>
</div>
<div class="flex items-center gap-4">
<span class="material-symbols-outlined text-4xl text-gray-400">verified_user</span>
<div>
<h4 class="font-bold">Trusted by Thousands</h4>
<p class="text-xs text-gray-500">Join a community of successful sellers.</p>
</div>
</div>
<div class="flex items-center gap-4">
<span class="material-symbols-outlined text-4xl text-gray-400">support_agent</span>
<div>
<h4 class="font-bold">24/7 Support</h4>
<p class="text-xs text-gray-500">We are here to help you grow.</p>
</div>
</div>
</div>
</section>
<section class="py-20 px-4 md:px-6">
<div class="w-full max-w-6xl mx-auto relative overflow-hidden rounded-[2rem] md:rounded-[3rem] bg-primary dark:bg-surface-dark text-white text-center py-16 md:py-24 px-6 shadow-2xl group">
<div class="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
<div class="absolute -top-[100px] -left-[100px] w-[300px] md:w-[500px] h-[300px] md:h-[500px] bg-emerald-400 opacity-30 blur-[120px] rounded-full group-hover:opacity-40 transition-opacity duration-1000"></div>
<div class="absolute -bottom-[100px] -right-[100px] w-[300px] md:w-[500px] h-[300px] md:h-[500px] bg-teal-400 opacity-20 blur-[120px] rounded-full group-hover:opacity-30 transition-opacity duration-1000"></div>
</div>
<div class="relative z-10 flex flex-col items-center max-w-3xl mx-auto">
<div class="w-16 h-16 md:w-20 md:h-20 bg-white/10 backdrop-blur-md rounded-2xl flex items-center justify-center mb-8 shadow-inner border border-white/20 rotate-3 group-hover:rotate-6 transition-transform duration-500">
<span class="font-display font-bold text-3xl md:text-4xl">Z</span>
</div>
<h2 class="text-3xl md:text-6xl font-display font-bold mb-6 md:mb-8 leading-tight">Ready to start selling?</h2>
<p class="text-gray-100 text-base md:text-xl mb-10 md:mb-12 max-w-xl mx-auto leading-relaxed">
                        Create your free store today. No credit card required.
                    </p>
<div class="flex flex-col sm:flex-row gap-5 w-full justify-center">
<a class="bg-white text-primary hover:bg-gray-100 font-bold py-4 px-10 rounded-full shadow-lg transition-all transform hover:scale-105 hover:shadow-xl text-lg flex items-center justify-center gap-2" href="app/register.php">
                            Create Store Now
                            <span class="material-symbols-outlined text-sm">arrow_forward</span>
</a>
<a class="bg-transparent border border-white/30 hover:bg-white/10 text-white font-semibold py-4 px-10 rounded-full transition-all text-lg backdrop-blur-sm flex items-center justify-center" href="#demo-footer">
                            View Demo Store
                        </a>
</div>
</div>
</div>
</section>
</main>
<footer class="bg-surface-light/50 dark:bg-black border-t border-border-light dark:border-border-dark py-12 md:py-20 px-6">
<div class="max-w-7xl mx-auto">
<div class="grid grid-cols-1 md:grid-cols-4 gap-12 mb-16">
<div class="col-span-1 md:col-span-1">
<h3 class="font-display font-bold text-2xl mb-6 flex items-center gap-2">
<div class="w-8 h-8 bg-primary text-white rounded-lg flex items-center justify-center text-lg">Z</div>
                        ziteo
                    </h3>
<p class="text-text-secondary-light dark:text-text-secondary-dark text-sm leading-relaxed mb-6">
                        The best platform for Instagram and WhatsApp sellers to build their online presence.
                    </p>
<div class="flex gap-4">
<a aria-label="Instagram" class="w-10 h-10 rounded-full bg-white dark:bg-surface-dark border border-gray-200 dark:border-gray-800 flex items-center justify-center hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors" href="#">
<span class="text-xs font-bold font-display">Ig</span>
</a>
<a aria-label="WhatsApp" class="w-10 h-10 rounded-full bg-white dark:bg-surface-dark border border-gray-200 dark:border-gray-800 flex items-center justify-center hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors" href="#">
<span class="text-xs font-bold font-display">Wa</span>
</a>
</div>
</div>
<div class="col-span-1 md:col-span-3 grid grid-cols-2 md:grid-cols-3 gap-8">
<div>
<h4 class="font-bold text-sm mb-6 uppercase tracking-wider text-gray-900 dark:text-white">Platform</h4>
<ul class="space-y-4 text-sm text-text-secondary-light dark:text-text-secondary-dark font-medium">
<li><a class="hover:text-primary transition-colors" href="#features">Features</a></li>
<li><a class="hover:text-primary transition-colors" href="#pricing">Pricing</a></li>
<li><a class="hover:text-primary transition-colors" href="#">Examples</a></li>
<li><a class="hover:text-primary transition-colors" href="app/login.php">Login</a></li>
</ul>
</div>
<div>
<h4 class="font-bold text-sm mb-6 uppercase tracking-wider text-gray-900 dark:text-white">Resources</h4>
<ul class="space-y-4 text-sm text-text-secondary-light dark:text-text-secondary-dark font-medium">
<li><a class="hover:text-primary transition-colors" href="#">Blog</a></li>
<li><a class="hover:text-primary transition-colors" href="#">Help Center</a></li>
<li><a class="hover:text-primary transition-colors" href="#">Seller Tips</a></li>
</ul>
</div>
<div>
<h4 class="font-bold text-sm mb-6 uppercase tracking-wider text-gray-900 dark:text-white">Legal</h4>
<ul class="space-y-4 text-sm text-text-secondary-light dark:text-text-secondary-dark font-medium">
<li><a class="hover:text-primary transition-colors" href="#">Privacy Policy</a></li>
<li><a class="hover:text-primary transition-colors" href="#">Terms of Service</a></li>
<li><a class="hover:text-primary transition-colors" href="#">Refund Policy</a></li>
</ul>
</div>
</div>
</div>
<div class="border-t border-border-light dark:border-border-dark pt-8 flex flex-col md:flex-row justify-between items-center text-xs text-gray-500 gap-4 font-medium">
<p>© 2024 Ziteo Inc. All rights reserved.</p>
</div>
</div>
</footer>

</body></html>