<?php

/**
 * About Page Template
 */
?>

<div class="container">
    <div class="about-page">
        <div class="about-header">
            <h1>About <?= e($store['name']) ?></h1>
        </div>

        <div class="about-content">
            <section class="about-section about-intro">
                <div class="about-text">
                    <h2>Welcome! 👋</h2>
                    <p>
                        Thank you for visiting <strong><?= e($store['name']) ?></strong>.
                        We're here to provide you with quality products and excellent service.
                    </p>
                    <p>
                        Browse our collection and order easily via WhatsApp.
                        We're always happy to help with any questions!
                    </p>
                </div>
            </section>

            <section class="about-section about-contact">
                <h2>📞 Contact Us</h2>
                <div class="contact-card">
                    <div class="contact-item">
                        <span class="contact-icon">💬</span>
                        <div class="contact-info">
                            <h4>WhatsApp</h4>
                            <a href="https://wa.me/91<?= e($store['whatsapp']) ?>">
                                +91 <?= e($store['whatsapp']) ?>
                            </a>
                        </div>
                    </div>
                </div>

                <a href="https://wa.me/91<?= e($store['whatsapp']) ?>" class="btn btn-whatsapp btn-large" target="_blank">
                    💬 Chat with us on WhatsApp
                </a>
            </section>

            <section class="about-section about-shop">
                <h2>🛍️ Start Shopping</h2>
                <p>Ready to explore our products?</p>
                <a href="<?= $storeUrl ?>/products" class="btn btn-primary btn-large">
                    Browse All Products →
                </a>
            </section>
        </div>
    </div>
</div>