<?php

/**
 * Template Configuration
 * Default Store Template
 */

return [
    'name' => 'Default',
    'version' => '1.0.0',

    // Template sections (for future customization)
    'sections' => [
        'header' => [
            'show_search' => true,
            'show_wishlist' => true,
            'show_categories' => true
        ],
        'home' => [
            'show_hero' => true,
            'show_featured' => true,
            'show_categories' => true,
            'featured_count' => 8
        ],
        'products' => [
            'show_filters' => true,
            'show_sort' => true,
            'products_per_page' => 12,
            'default_view' => 'grid' // grid or list
        ],
        'footer' => [
            'show_whatsapp' => true,
            'show_branding' => true
        ]
    ],

    // Default colors (overridden by store theme_config)
    'colors' => [
        'primary' => '#25D366',
        'secondary' => '#6366f1',
        'dark' => '#0f172a',
        'light' => '#f8fafc'
    ]
];
