<?php

/**
 * Single Product Details Page Template
 */

$productImage = $product['image'] ? $uploadsUrl . '/uploads/' . $store['id'] . '/' . $product['image'] : null;
$productPrice = $product['offer_price'] ?: $product['price'];
$hasDiscount = !empty($product['offer_price']);
$variants = json_decode($product['variants'] ?? '{}', true);
$customData = json_decode($product['custom_data'] ?? '{}', true);
?>

<div class="container">
    <nav class="breadcrumb">
        <a href="<?= $storeUrl ?>/">Home</a>
        <span>/</span>
        <a href="<?= $storeUrl ?>/products">Products</a>
        <span>/</span>
        <span><?= e($product['name']) ?></span>
    </nav>

    <div class="product-detail">
        <!-- Product Image -->
        <div class="product-detail-image">
            <?php if ($productImage): ?>
                <img src="<?= e($productImage) ?>" alt="<?= e($product['name']) ?>" id="mainImage">
            <?php else: ?>
                <div class="no-image-large">📦</div>
            <?php endif; ?>

            <?php if ($hasDiscount): ?>
                <?php $discount = round((($product['price'] - $product['offer_price']) / $product['price']) * 100); ?>
                <span class="discount-badge-large">-<?= $discount ?>% OFF</span>
            <?php endif; ?>
        </div>

        <!-- Product Info -->
        <div class="product-detail-info">
            <?php if (!empty($product['category_name'])): ?>
                <span class="product-category-badge"><?= e($product['category_name']) ?></span>
            <?php endif; ?>

            <h1 class="product-detail-title"><?= e($product['name']) ?></h1>

            <div class="product-detail-price">
                <?php if ($hasDiscount): ?>
                    <span class="price-strike-large"><?= formatPrice($product['price']) ?></span>
                <?php endif; ?>
                <span class="price-current-large" id="displayPrice"><?= formatPrice($productPrice) ?></span>
                <?php if ($hasDiscount): ?>
                    <span class="price-save">You save <?= formatPrice($product['price'] - $product['offer_price']) ?></span>
                <?php endif; ?>
            </div>

            <div class="product-stock <?= $product['stock_status'] ?>">
                <?= $product['stock_status'] === 'in_stock' ? '✓ In Stock' : '✗ Out of Stock' ?>
            </div>

            <!-- Color Variants -->
            <?php if (!empty($variants['colors'])): ?>
                <div class="variant-section">
                    <h4>Color</h4>
                    <div class="variant-options">
                        <?php foreach ($variants['colors'] as $i => $color): ?>
                            <button type="button"
                                class="variant-btn <?= $i === 0 ? 'active' : '' ?>"
                                data-variant="color"
                                data-name="<?= e($color['name']) ?>"
                                data-price="<?= $color['price_adjustment'] ?>"
                                onclick="selectVariant(this)">
                                <?= e($color['name']) ?>
                                <?php if ($color['price_adjustment'] > 0): ?>
                                    <span class="variant-price">+<?= formatPrice($color['price_adjustment']) ?></span>
                                <?php endif; ?>
                            </button>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Size Variants -->
            <?php if (!empty($variants['sizes'])): ?>
                <div class="variant-section">
                    <h4>Size</h4>
                    <div class="variant-options">
                        <?php foreach ($variants['sizes'] as $i => $size): ?>
                            <button type="button"
                                class="variant-btn <?= $i === 0 ? 'active' : '' ?>"
                                data-variant="size"
                                data-name="<?= e($size['name']) ?>"
                                data-price="<?= $size['price_adjustment'] ?>"
                                onclick="selectVariant(this)">
                                <?= e($size['name']) ?>
                                <?php if ($size['price_adjustment'] > 0): ?>
                                    <span class="variant-price">+<?= formatPrice($size['price_adjustment']) ?></span>
                                <?php endif; ?>
                            </button>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Description -->
            <?php if (!empty($product['description'])): ?>
                <div class="product-description">
                    <h4>Description</h4>
                    <p><?= nl2br(e($product['description'])) ?></p>
                </div>
            <?php endif; ?>

            <!-- Custom Fields -->
            <?php if (!empty($customData)): ?>
                <div class="product-specs">
                    <h4>Specifications</h4>
                    <table class="specs-table">
                        <?php foreach ($customData as $key => $value): ?>
                            <?php if (!empty($value)): ?>
                                <tr>
                                    <td><?= e($key) ?></td>
                                    <td><?= e($value) ?></td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </table>
                </div>
            <?php endif; ?>

            <!-- Action Buttons -->
            <div class="product-detail-actions">
                <button class="btn btn-wishlist-large"
                    onclick="addToWishlist(<?= $product['id'] ?>, '<?= e(addslashes($product['name'])) ?>', '<?= e($productImage) ?>', <?= $productPrice ?>)">
                    ❤️ Add to Wishlist
                </button>

                <?php if ($product['stock_status'] === 'in_stock'): ?>
                    <a href="#" id="orderBtn" class="btn btn-whatsapp btn-large" target="_blank">
                        💬 Order on WhatsApp
                    </a>
                <?php else: ?>
                    <button class="btn btn-disabled btn-large" disabled>Sold Out</button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
    const basePrice = <?= $productPrice ?>;
    const whatsappNumber = '91<?= e($store['whatsapp']) ?>';
    const productName = '<?= e(addslashes($product['name'])) ?>';
    let selectedVariants = {
        color: '',
        size: ''
    };
    let totalPriceAdjustment = 0;

    function selectVariant(btn) {
        const variantType = btn.dataset.variant;
        const variantName = btn.dataset.name;
        const priceAdjustment = parseInt(btn.dataset.price) || 0;

        // Update selection
        btn.parentElement.querySelectorAll('.variant-btn').forEach(b => b.classList.remove('active'));
        btn.classList.add('active');

        selectedVariants[variantType] = variantName;

        // Recalculate total price adjustment
        totalPriceAdjustment = 0;
        document.querySelectorAll('.variant-btn.active').forEach(activeBtn => {
            totalPriceAdjustment += parseInt(activeBtn.dataset.price) || 0;
        });

        updatePrice();
        updateOrderLink();
    }

    function formatPrice(paise) {
        return '₹' + (paise / 100).toLocaleString('en-IN');
    }

    function updatePrice() {
        const finalPrice = basePrice + totalPriceAdjustment;
        document.getElementById('displayPrice').textContent = formatPrice(finalPrice);
    }

    function updateOrderLink() {
        const finalPrice = basePrice + totalPriceAdjustment;
        let message = `Hi, I want to order: ${productName}`;

        if (selectedVariants.color) message += ` (Color: ${selectedVariants.color})`;
        if (selectedVariants.size) message += ` (Size: ${selectedVariants.size})`;
        message += ` - ${formatPrice(finalPrice)}`;

        const orderBtn = document.getElementById('orderBtn');
        if (orderBtn) {
            orderBtn.href = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(message)}`;
        }
    }

    // Initialize
    document.addEventListener('DOMContentLoaded', function() {
        // Set initial variant selections
        document.querySelectorAll('.variant-btn.active').forEach(btn => {
            selectedVariants[btn.dataset.variant] = btn.dataset.name;
            totalPriceAdjustment += parseInt(btn.dataset.price) || 0;
        });
        updatePrice();
        updateOrderLink();
    });
</script>