<?php

/**
 * Products Listing Page Template
 */

// Get filter values
$categoryFilter = $_GET['category'] ?? '';
$sortBy = $_GET['sort'] ?? 'newest';
$minPrice = $_GET['min_price'] ?? '';
$maxPrice = $_GET['max_price'] ?? '';
?>

<div class="container">
    <div class="page-header">
        <h1>All Products</h1>
        <span class="product-count"><?= count($products) ?> products</span>
    </div>

    <div class="products-layout">
        <!-- Filters Sidebar -->
        <aside class="filters-sidebar" id="filtersSidebar">
            <div class="filters-header">
                <h3>Filters</h3>
                <button class="filters-close" onclick="toggleFilters()">×</button>
            </div>

            <form action="<?= $storeUrl ?>/products" method="GET" class="filters-form">
                <!-- Category Filter -->
                <?php if (!empty($categories)): ?>
                    <div class="filter-group">
                        <h4>Category</h4>
                        <div class="filter-options">
                            <label class="filter-option">
                                <input type="radio" name="category" value="" <?= empty($categoryFilter) ? 'checked' : '' ?>>
                                <span>All Categories</span>
                            </label>
                            <?php foreach ($categories as $cat): ?>
                                <label class="filter-option">
                                    <input type="radio" name="category" value="<?= $cat['id'] ?>"
                                        <?= $categoryFilter == $cat['id'] ? 'checked' : '' ?>>
                                    <span><?= e($cat['name']) ?> (<?= $cat['product_count'] ?? 0 ?>)</span>
                                </label>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Price Range Filter -->
                <div class="filter-group">
                    <h4>Price Range</h4>
                    <div class="price-range-inputs">
                        <input type="number" name="min_price" placeholder="Min"
                            value="<?= e($minPrice) ?>" min="0">
                        <span>to</span>
                        <input type="number" name="max_price" placeholder="Max"
                            value="<?= e($maxPrice) ?>" min="0">
                    </div>
                </div>

                <!-- Sort -->
                <div class="filter-group">
                    <h4>Sort By</h4>
                    <select name="sort" class="sort-select">
                        <option value="newest" <?= $sortBy === 'newest' ? 'selected' : '' ?>>Newest First</option>
                        <option value="price_low" <?= $sortBy === 'price_low' ? 'selected' : '' ?>>Price: Low to High</option>
                        <option value="price_high" <?= $sortBy === 'price_high' ? 'selected' : '' ?>>Price: High to Low</option>
                        <option value="name_asc" <?= $sortBy === 'name_asc' ? 'selected' : '' ?>>Name: A to Z</option>
                    </select>
                </div>

                <button type="submit" class="btn btn-primary btn-block">Apply Filters</button>
                <a href="<?= $storeUrl ?>/products" class="btn btn-outline btn-block">Clear All</a>
            </form>
        </aside>

        <!-- Products Grid -->
        <div class="products-content">
            <!-- Mobile Filter Toggle -->
            <div class="mobile-filter-bar">
                <button class="btn btn-outline" onclick="toggleFilters()">
                    🔧 Filters
                </button>
                <select onchange="window.location.href='<?= $storeUrl ?>/products?sort=' + this.value">
                    <option value="newest" <?= $sortBy === 'newest' ? 'selected' : '' ?>>Newest</option>
                    <option value="price_low" <?= $sortBy === 'price_low' ? 'selected' : '' ?>>Price ↑</option>
                    <option value="price_high" <?= $sortBy === 'price_high' ? 'selected' : '' ?>>Price ↓</option>
                </select>
            </div>

            <?php if (empty($products)): ?>
                <div class="empty-state">
                    <span class="empty-icon">📦</span>
                    <h3>No products found</h3>
                    <p>Try adjusting your filters or check back later.</p>
                    <a href="<?= $storeUrl ?>/products" class="btn btn-primary">Clear Filters</a>
                </div>
            <?php else: ?>
                <div class="products-grid">
                    <?php foreach ($products as $product): ?>
                        <?php include __DIR__ . '/partials/product-card.php'; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
    function toggleFilters() {
        document.getElementById('filtersSidebar').classList.toggle('active');
        document.body.classList.toggle('filters-open');
    }
</script>