<?php

/**
 * Search Results Page Template
 */
$query = $_GET['q'] ?? '';
?>

<div class="container">
    <div class="search-page">
        <div class="search-header">
            <h1>Search Products</h1>
            <form action="<?= $storeUrl ?>/search" method="GET" class="search-page-form">
                <input type="text" name="q" value="<?= e($query) ?>"
                    placeholder="What are you looking for?" autofocus>
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>

        <?php if (!empty($query)): ?>
            <div class="search-results-info">
                <p>
                    <?php if (!empty($products)): ?>
                        Found <strong><?= count($products) ?></strong> products for "<strong><?= e($query) ?></strong>"
                    <?php else: ?>
                        No products found for "<strong><?= e($query) ?></strong>"
                    <?php endif; ?>
                </p>
            </div>

            <?php if (!empty($products)): ?>
                <div class="products-grid">
                    <?php foreach ($products as $product): ?>
                        <?php include __DIR__ . '/partials/product-card.php'; ?>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <span class="empty-icon">🔍</span>
                    <h3>No results found</h3>
                    <p>Try different keywords or browse all products</p>
                    <a href="<?= $storeUrl ?>/products" class="btn btn-primary">Browse Products</a>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <div class="search-suggestions">
                <h3>Popular Categories</h3>
                <?php if (!empty($categories)): ?>
                    <div class="suggestion-tags">
                        <?php foreach ($categories as $cat): ?>
                            <a href="<?= $storeUrl ?>/products?category=<?= $cat['id'] ?>" class="suggestion-tag">
                                <?= e($cat['name']) ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <h3>Recent Products</h3>
                <?php if (!empty($recentProducts)): ?>
                    <div class="products-grid products-grid-small">
                        <?php foreach (array_slice($recentProducts, 0, 4) as $product): ?>
                            <?php include __DIR__ . '/partials/product-card.php'; ?>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>