<?php

/**
 * Auth API Endpoints
 */

function register(): void
{
    $data = json_decode(file_get_contents('php://input'), true);

    $name = trim($data['name'] ?? '');
    $email = trim($data['email'] ?? '');
    $password = $data['password'] ?? '';
    $phone = trim($data['phone'] ?? '');

    // Validation
    if (empty($name) || strlen($name) < 2) {
        jsonError('Name is required (min 2 characters)');
    }

    if (!isValidEmail($email)) {
        jsonError('Valid email is required');
    }

    if (strlen($password) < 6) {
        jsonError('Password must be at least 6 characters');
    }

    if (!empty($phone) && !isValidPhone($phone)) {
        jsonError('Invalid phone number format');
    }

    $result = registerUser($name, $email, $password, $phone);

    if ($result['success']) {
        jsonSuccess(['user_id' => $result['user_id']], 'Registration successful');
    } else {
        jsonError($result['error']);
    }
}

function login(): void
{
    $data = json_decode(file_get_contents('php://input'), true);

    $email = trim($data['email'] ?? '');
    $password = $data['password'] ?? '';

    if (empty($email) || empty($password)) {
        jsonError('Email and password are required');
    }

    $result = loginUser($email, $password);

    if ($result['success']) {
        jsonSuccess(['user_id' => $result['user_id']], 'Login successful');
    } else {
        jsonError($result['error']);
    }
}

function logout(): void
{
    logoutUser();
    jsonSuccess([], 'Logged out successfully');
}
