<?php

/**
 * ZITEO Final Migration Script
 * Call this via browser to fix schema issues.
 */
require_once dirname(__DIR__, 2) . '/includes/db.php';

echo "<h1>Ziteo Database Migration</h1>";

try {
    $pdo = db();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // 1. Update plans table
    echo "Updating plans table...<br>";
    $stmt = $pdo->query("SHOW COLUMNS FROM plans LIKE 'store_limit'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE plans ADD COLUMN store_limit INT NOT NULL DEFAULT 1 AFTER price");
        echo " - Added 'store_limit' column.<br>";
    }

    // 2. Update users table
    echo "Updating users table...<br>";
    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'plan_id'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE users ADD COLUMN plan_id INT UNSIGNED DEFAULT NULL AFTER phone");
        $pdo->exec("ALTER TABLE users ADD CONSTRAINT users_plan_fk FOREIGN KEY (plan_id) REFERENCES plans(id) ON DELETE SET NULL");
        echo " - Added 'plan_id' column and foreign key.<br>";
    }

    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'plan_status'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE users ADD COLUMN plan_status ENUM('pending', 'active', 'expired') NOT NULL DEFAULT 'pending' AFTER plan_id");
        echo " - Added 'plan_status' column.<br>";
    }

    // 3. Add/Update Plans
    echo "Configuring plans...<br>";

    $plans = [
        ['name' => 'Free', 'price' => 0, 'product_limit' => 10, 'store_limit' => 1, 'features' => '{"whatsapp_orders": true, "analytics": false, "custom_domain": false}'],
        ['name' => 'Basic', 'price' => 4900, 'product_limit' => 15, 'store_limit' => 1, 'features' => '{"whatsapp_orders": true, "analytics": true, "custom_domain": false}'],
        ['name' => 'Standard', 'price' => 9900, 'product_limit' => 50, 'store_limit' => 2, 'features' => '{"whatsapp_orders": true, "analytics": true, "custom_domain": true}'],
        ['name' => 'Pro', 'price' => 19900, 'product_limit' => 200, 'store_limit' => 5, 'features' => '{"whatsapp_orders": true, "analytics": true, "custom_domain": true}']
    ];

    foreach ($plans as $p) {
        $stmt = $pdo->prepare("SELECT id FROM plans WHERE name = ?");
        $stmt->execute([$p['name']]);
        $existing = $stmt->fetch();

        if ($existing) {
            $stmt = $pdo->prepare("UPDATE plans SET price = ?, product_limit = ?, store_limit = ?, features = ? WHERE name = ?");
            $stmt->execute([$p['price'], $p['product_limit'], $p['store_limit'], $p['features'], $p['name']]);
            echo " - Updated '{$p['name']}' plan.<br>";
        } else {
            $stmt = $pdo->prepare("INSERT INTO plans (name, price, product_limit, store_limit, features, is_active) VALUES (?, ?, ?, ?, ?, 1)");
            $stmt->execute([$p['name'], $p['price'], $p['product_limit'], $p['store_limit'], $p['features']]);
            echo " - Created '{$p['name']}' plan.<br>";
        }
    }

    // 4. Update existing users to Free plan if they have null plan_id
    echo "Updating existing users without plans...<br>";
    $stmt = $pdo->prepare("SELECT id FROM plans WHERE name = 'Free'");
    $stmt->execute();
    $freePlanId = $stmt->fetchColumn();

    if ($freePlanId) {
        $stmt = $pdo->prepare("UPDATE users SET plan_id = ?, plan_status = 'active' WHERE plan_id IS NULL");
        $stmt->execute([$freePlanId]);
        echo " - Assigned Free plan to all existing users.<br>";
    }

    echo "<h3>Migration Successful!</h3>";
    echo "<p>You can now delete this file or keep it for reference.</p>";
    echo "<a href='dashboard.php'>Go to Dashboard</a>";
} catch (Exception $e) {
    echo "<h3 style='color:red'>Migration Failed!</h3>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
}
