<?php
require_once dirname(__DIR__, 2) . '/includes/db.php';

try {
    $pdo = db();

    // Add store_limit to plans table if checks fail
    try {
        $stmt = $pdo->query("SELECT store_limit FROM plans LIMIT 1");
    } catch (PDOException $e) {
        $pdo->exec("ALTER TABLE plans ADD COLUMN store_limit INT NOT NULL DEFAULT 1 AFTER price");
        echo "Added store_limit to plans.\n";
    }

    // Update plan limits
    $pdo->exec("UPDATE plans SET store_limit = 1 WHERE name = 'Basic'");
    $pdo->exec("UPDATE plans SET store_limit = 2 WHERE name = 'Standard'");
    $pdo->exec("UPDATE plans SET store_limit = 5 WHERE name = 'Pro'");
    echo "Updated plan limits.\n";

    echo "Database re-verification completed.";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
