<?php

/**
 * Select Plan
 * app.ziteo.in/select_plan.php
 */
session_start();
require_once dirname(__DIR__, 2) . '/includes/auth.php';
requireAuth();

$pdo = db();
$user = getCurrentUser();

// If method is POST, handle selection
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $planName = $_POST['plan_name'] ?? '';

    // Validate plan
    $stmt = $pdo->prepare("SELECT id FROM plans WHERE name = ?");
    $stmt->execute([$planName]);
    $plan = $stmt->fetch();

    if ($plan) {
        $stmt = $pdo->prepare("UPDATE users SET plan_id = ?, plan_status = 'pending' WHERE id = ?");
        $stmt->execute([$plan['id'], $user['id']]);
        header('Location: dashboard.php');
        exit;
    }
}

// Show plans
$stmt = $pdo->query("SELECT * FROM plans WHERE is_active = 1 ORDER BY price ASC");
$plans = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Select Plan - Ziteo</title>
    <script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1" rel="stylesheet" />
    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
        }
    </style>
</head>

<body class="bg-gray-50 dark:bg-gray-900 text-gray-900 dark:text-white min-h-screen flex items-center justify-center p-4">

    <div class="max-w-4xl w-full">
        <div class="text-center mb-10">
            <h1 class="text-3xl font-bold mb-2">Select a Plan</h1>
            <p class="text-gray-500">Choose a plan that fits your business needs.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <?php foreach ($plans as $plan): ?>
                <?php
                $features = json_decode($plan['features'] ?? '{}', true);
                $isPopular = $plan['name'] === 'Standard';
                $cardClass = $isPopular ? 'border-2 border-indigo-600 shadow-xl scale-105 z-10' : 'border border-gray-200 dark:border-gray-800 shadow-sm hover:shadow-lg';
                ?>
                <div class="bg-white dark:bg-gray-800 rounded-2xl p-6 relative flex flex-col <?= $cardClass ?> transition-all">
                    <?php if ($isPopular): ?>
                        <div class="absolute top-0 left-1/2 -translate-x-1/2 -translate-y-1/2 bg-indigo-600 text-white px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wide">Most Popular</div>
                    <?php endif; ?>

                    <h3 class="text-xl font-bold mb-2"><?= e($plan['name']) ?></h3>
                    <?php if ($plan['id'] == $user['plan_id']): ?>
                        <span class="inline-block bg-green-100 text-green-700 px-2 py-0.5 rounded text-[10px] font-bold uppercase mb-2">Current Plan</span>
                    <?php endif; ?>

                    <div class="flex items-end gap-1 mb-6">
                        <span class="text-3xl font-bold">₹<?= $plan['price'] / 100 ?></span>
                        <span class="text-gray-500 text-sm mb-1">/mo</span>
                    </div>

                    <div class="flex-grow space-y-3 mb-8">
                        <div class="flex items-center gap-2 text-sm font-medium">
                            <span class="material-symbols-outlined text-green-500 text-lg">store</span>
                            <span><?= $plan['store_limit'] ?? 1 ?> Store<?= ($plan['store_limit'] ?? 1) > 1 ? 's' : '' ?></span>
                        </div>
                        <?php if (!empty($features['whatsapp_orders'])): ?>
                            <div class="flex items-center gap-2 text-sm text-gray-600 dark:text-gray-300">
                                <span class="material-symbols-outlined text-green-500 text-lg">check</span>
                                <span>WhatsApp Orders</span>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($features['analytics'])): ?>
                            <div class="flex items-center gap-2 text-sm text-gray-600 dark:text-gray-300">
                                <span class="material-symbols-outlined text-green-500 text-lg">check</span>
                                <span>Analytics</span>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($features['custom_domain'])): ?>
                            <div class="flex items-center gap-2 text-sm text-gray-600 dark:text-gray-300">
                                <span class="material-symbols-outlined text-green-500 text-lg">check</span>
                                <span>Custom Domain</span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if ($plan['id'] == $user['plan_id']): ?>
                        <button disabled class="w-full py-2.5 rounded-xl font-semibold bg-gray-100 text-gray-400 cursor-not_allowed">
                            Selected
                        </button>
                    <?php else: ?>
                        <form method="POST">
                            <input type="hidden" name="plan_name" value="<?= e($plan['name']) ?>">
                            <button type="submit" class="w-full py-2.5 rounded-xl font-semibold transition-colors <?= $isPopular ? 'bg-indigo-600 hover:bg-indigo-700 text-white' : 'bg-gray-100 hover:bg-gray-200 dark:bg-gray-700 dark:hover:bg-gray-600' ?>">
                                <?= empty($user['plan_id']) ? 'Select Plan' : 'Upgrade Plan' ?>
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

</body>

</html>