<?php
require_once dirname(__DIR__, 2) . '/includes/db.php';

try {
    $pdo = db();

    // Add store_limit to plans table
    $stmt = $pdo->query("SHOW COLUMNS FROM plans LIKE 'store_limit'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE plans ADD COLUMN store_limit INT NOT NULL DEFAULT 1 AFTER price");
        echo "Added store_limit to plans.\n";
    }

    // Update plan limits
    $pdo->exec("UPDATE plans SET store_limit = 1 WHERE name = 'Basic'");
    $pdo->exec("UPDATE plans SET store_limit = 2 WHERE name = 'Standard'");
    $pdo->exec("UPDATE plans SET store_limit = 5 WHERE name = 'Pro'");
    echo "Updated plan limits.\n";

    // Add plan_id and plan_status to users table
    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'plan_id'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE users ADD COLUMN plan_id INT UNSIGNED DEFAULT NULL AFTER phone");
        $pdo->exec("ALTER TABLE users ADD CONSTRAINT users_plan_fk FOREIGN KEY (plan_id) REFERENCES plans(id) ON DELETE SET NULL");
        echo "Added plan_id to users.\n";
    }

    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'plan_status'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE users ADD COLUMN plan_status ENUM('pending', 'active', 'expired') NOT NULL DEFAULT 'pending' AFTER plan_id");
        echo "Added plan_status to users.\n";
    }

    echo "Database update completed successfully.";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
