<?php

/**
 * Wizard Step 1: Store Basics
 * Collects store name, WhatsApp number, and optional city
 */

$error = '';
$data = $_SESSION['wizard_data'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $storeName = trim($_POST['store_name'] ?? '');
    $whatsapp = preg_replace('/[^0-9]/', '', $_POST['whatsapp'] ?? '');
    $city = trim($_POST['city'] ?? '');
    $slug = slugify($storeName);

    // Validation
    if (empty($storeName) || strlen($storeName) < 3) {
        $error = 'Store name must be at least 3 characters';
    } elseif (empty($whatsapp) || !isValidPhone($whatsapp)) {
        $error = 'Please enter a valid 10-digit WhatsApp number';
    } else {
        // Check slug uniqueness
        $stmt = $pdo->prepare("SELECT id FROM stores WHERE slug = ?");
        $stmt->execute([$slug]);
        if ($stmt->fetch()) {
            $slug = $slug . '-' . rand(100, 999);
        }

        // Save to session and proceed
        $_SESSION['wizard_data']['store_name'] = $storeName;
        $_SESSION['wizard_data']['whatsapp'] = $whatsapp;
        $_SESSION['wizard_data']['city'] = $city;
        $_SESSION['wizard_data']['slug'] = $slug;
        $_SESSION['wizard_data']['step'] = 2;

        header('Location: wizard.php?step=2');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Your Store - ZITEO</title>
    <link rel="stylesheet" href="../assets/css/dashboard.css">
    <link rel="stylesheet" href="../assets/css/wizard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>
    <div class="wizard-container">
        <!-- Progress Steps -->
        <div class="wizard-progress">
            <div class="progress-step active">
                <div class="step-number">1</div>
                <div class="step-label">Basics</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">2</div>
                <div class="step-label">Category</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">3</div>
                <div class="step-label">Product</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">4</div>
                <div class="step-label">Template</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">5</div>
                <div class="step-label">Publish</div>
            </div>
        </div>

        <!-- Step Content -->
        <div class="wizard-content">
            <div class="wizard-header">
                <h1>Let's set up your store</h1>
                <p>Tell us about your business</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-error"><?= e($error) ?></div>
            <?php endif; ?>

            <form method="POST" class="wizard-form">
                <div class="form-group">
                    <label for="store_name">Store Name *</label>
                    <input type="text" id="store_name" name="store_name" required
                        value="<?= e($data['store_name'] ?? $_POST['store_name'] ?? '') ?>"
                        placeholder="e.g., Riya's Fashion Hub">
                    <small>This is what customers will see</small>
                </div>

                <div class="form-group">
                    <label for="whatsapp">WhatsApp Number *</label>
                    <div class="input-group">
                        <span class="input-prefix">+91</span>
                        <input type="tel" id="whatsapp" name="whatsapp" required
                            value="<?= e($data['whatsapp'] ?? $_POST['whatsapp'] ?? '') ?>"
                            placeholder="9876543210" maxlength="10">
                    </div>
                    <small>Customers will contact you here</small>
                </div>

                <div class="form-group">
                    <label for="city">City (Optional)</label>
                    <input type="text" id="city" name="city"
                        value="<?= e($data['city'] ?? $_POST['city'] ?? '') ?>"
                        placeholder="e.g., Mumbai">
                    <small>Helps local customers find you</small>
                </div>

                <div class="wizard-actions">
                    <div></div>
                    <button type="submit" class="btn btn-primary btn-large">
                        Next →
                    </button>
                </div>
            </form>
        </div>
    </div>
</body>

</html>