<?php

/**
 * Wizard Step 3: Add First Product
 * Mandatory product creation - cannot skip
 */

$error = '';
$data = $_SESSION['wizard_data'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $productName = trim($_POST['product_name'] ?? '');
    $productPrice = (int)($_POST['product_price'] ?? 0);
    $productDesc = trim($_POST['product_description'] ?? '');

    // Handle image upload
    $imagePath = null;
    if (isset($_FILES['product_image']) && $_FILES['product_image']['error'] === UPLOAD_ERR_OK) {
        // Store temporarily in session, will move to proper location on publish
        $tmpName = $_FILES['product_image']['tmp_name'];
        $originalName = $_FILES['product_image']['name'];
        $ext = pathinfo($originalName, PATHINFO_EXTENSION);
        $tempFileName = 'wizard_' . currentUserId() . '_' . uniqid() . '.' . $ext;
        $tempPath = UPLOAD_PATH . '/temp/' . $tempFileName;

        if (!is_dir(UPLOAD_PATH . '/temp')) {
            mkdir(UPLOAD_PATH . '/temp', 0755, true);
        }

        if (move_uploaded_file($tmpName, $tempPath)) {
            $imagePath = $tempFileName;
        }
    }

    // Validation
    if (empty($productName) || strlen($productName) < 2) {
        $error = 'Product name must be at least 2 characters';
    } elseif ($productPrice <= 0) {
        $error = 'Please enter a valid price';
    } else {
        $_SESSION['wizard_data']['product'] = [
            'name' => $productName,
            'price' => $productPrice,
            'description' => $productDesc,
            'image' => $imagePath ?: ($data['product']['image'] ?? null)
        ];
        $_SESSION['wizard_data']['step'] = 4;

        header('Location: wizard.php?step=4');
        exit;
    }
}

$product = $data['product'] ?? [];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Your First Product - ZITEO</title>
    <link rel="stylesheet" href="../assets/css/dashboard.css">
    <link rel="stylesheet" href="../assets/css/wizard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>
    <div class="wizard-container">
        <!-- Progress Steps -->
        <div class="wizard-progress">
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Basics</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Category</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step active">
                <div class="step-number">3</div>
                <div class="step-label">Product</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">4</div>
                <div class="step-label">Template</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">5</div>
                <div class="step-label">Publish</div>
            </div>
        </div>

        <!-- Step Content -->
        <div class="wizard-content">
            <div class="wizard-header">
                <h1>Add your first product</h1>
                <p>Every store needs at least one product to get started</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-error"><?= e($error) ?></div>
            <?php endif; ?>

            <form method="POST" enctype="multipart/form-data" class="wizard-form">
                <div class="form-group">
                    <label for="product_name">Product Name *</label>
                    <input type="text" id="product_name" name="product_name" required
                        value="<?= e($product['name'] ?? $_POST['product_name'] ?? '') ?>"
                        placeholder="e.g., Red Silk Saree">
                </div>

                <div class="form-group">
                    <label for="product_price">Price (₹) *</label>
                    <input type="number" id="product_price" name="product_price" required min="1"
                        value="<?= e($product['price'] ?? $_POST['product_price'] ?? '') ?>"
                        placeholder="999">
                </div>

                <div class="form-group">
                    <label for="product_description">Description (Optional)</label>
                    <textarea id="product_description" name="product_description" rows="3"
                        placeholder="Describe your product..."><?= e($product['description'] ?? $_POST['product_description'] ?? '') ?></textarea>
                </div>

                <div class="form-group">
                    <label for="product_image">Product Image (Optional)</label>
                    <div class="image-upload-wrapper">
                        <input type="file" id="product_image" name="product_image" accept="image/*">
                        <div class="image-preview" id="imagePreview">
                            <?php if (!empty($product['image'])): ?>
                                <img src="/uploads/temp/<?= e($product['image']) ?>" alt="Product">
                            <?php else: ?>
                                <span class="preview-placeholder">📷 Click to upload</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <small>Max 5MB. JPG, PNG, or WebP</small>
                </div>

                <div class="wizard-actions">
                    <a href="wizard.php?step=2" class="btn btn-outline">← Back</a>
                    <button type="submit" class="btn btn-primary btn-large">
                        Next →
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Image preview
        const imageInput = document.getElementById('product_image');
        const imagePreview = document.getElementById('imagePreview');

        imagePreview.addEventListener('click', () => imageInput.click());

        imageInput.addEventListener('change', function() {
            if (this.files && this.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    imagePreview.innerHTML = '<img src="' + e.target.result + '" alt="Preview">';
                };
                reader.readAsDataURL(this.files[0]);
            }
        });
    </script>
</body>

</html>