<?php

/**
 * Wizard Step 4: Choose Template
 * User selects a visual template for their store
 */

$error = '';
$data = $_SESSION['wizard_data'];

// Get templates from database
$templates = $pdo->query("SELECT * FROM store_templates WHERE is_active = 1")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $templateId = (int)($_POST['template_id'] ?? 0);

    // Validate template exists
    $stmt = $pdo->prepare("SELECT * FROM store_templates WHERE id = ?");
    $stmt->execute([$templateId]);
    $template = $stmt->fetch();

    if (!$template) {
        $error = 'Please select a template for your store';
    } else {
        $_SESSION['wizard_data']['template_id'] = $templateId;
        $_SESSION['wizard_data']['template_name'] = $template['name'];
        $_SESSION['wizard_data']['theme_config'] = $template['theme_config'];
        $_SESSION['wizard_data']['step'] = 5;

        header('Location: wizard.php?step=5');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Choose Template - ZITEO</title>
    <link rel="stylesheet" href="../assets/css/dashboard.css">
    <link rel="stylesheet" href="../assets/css/wizard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>
    <div class="wizard-container">
        <!-- Progress Steps -->
        <div class="wizard-progress">
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Basics</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Category</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step completed">
                <div class="step-number">✓</div>
                <div class="step-label">Product</div>
            </div>
            <div class="progress-line completed"></div>
            <div class="progress-step active">
                <div class="step-number">4</div>
                <div class="step-label">Template</div>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step">
                <div class="step-number">5</div>
                <div class="step-label">Publish</div>
            </div>
        </div>

        <!-- Step Content -->
        <div class="wizard-content">
            <div class="wizard-header">
                <h1>Choose your store style</h1>
                <p>Pick a template that matches your brand</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-error"><?= e($error) ?></div>
            <?php endif; ?>

            <form method="POST" class="wizard-form" id="templateForm">
                <input type="hidden" name="template_id" id="templateInput" value="<?= e($data['template_id'] ?? '') ?>">

                <div class="template-grid">
                    <?php foreach ($templates as $tpl): ?>
                        <div class="template-card <?= ($data['template_id'] ?? 0) == $tpl['id'] ? 'selected' : '' ?>"
                            data-id="<?= $tpl['id'] ?>">
                            <div class="template-preview" style="background: <?= e($tpl['preview_color']) ?>">
                                <div class="template-preview-header"></div>
                                <div class="template-preview-content">
                                    <div class="preview-product"></div>
                                    <div class="preview-product"></div>
                                </div>
                            </div>
                            <div class="template-info">
                                <span class="template-name"><?= e($tpl['name']) ?></span>
                                <span class="template-color" style="background: <?= e($tpl['preview_color']) ?>"></span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="wizard-actions">
                    <a href="wizard.php?step=3" class="btn btn-outline">← Back</a>
                    <button type="submit" class="btn btn-primary btn-large">
                        Next →
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Template card selection
        document.querySelectorAll('.template-card').forEach(card => {
            card.addEventListener('click', function() {
                document.querySelectorAll('.template-card').forEach(c => c.classList.remove('selected'));
                this.classList.add('selected');
                document.getElementById('templateInput').value = this.dataset.id;
            });
        });
    </script>
</body>

</html>