<?php

/**
 * ZITEO Landing Page
 * ziteo.in
 */
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ZITEO - Create Your WhatsApp Store in 30 Seconds</title>
    <meta name="description" content="Turn your WhatsApp into a professional online store. No coding, no heavy costs, just business. Perfect for small sellers in India.">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>
    <!-- Header -->
    <header class="header">
        <div class="container">
            <a href="/" class="logo">ZITEO</a>
            <nav class="nav">
                <a href="#features">Features</a>
                <a href="#pricing">Pricing</a>
                <a href="https://app.ziteo.in/login.php" class="btn btn-outline">Login</a>
                <a href="https://app.ziteo.in/register.php" class="btn btn-primary">Start Free</a>
            </nav>
        </div>
    </header>

    <!-- Hero -->
    <section class="hero">
        <div class="container">
            <h1>Turn Your WhatsApp Into a<br><span class="highlight">Professional Online Store</span></h1>
            <p class="hero-subtitle">Create your store in 30 seconds. Share one link. Get orders on WhatsApp.<br>No coding. No heavy costs. Just business.</p>
            <a href="https://app.ziteo.in/register.php" class="btn btn-primary btn-large">Create Your Free Store →</a>
            <p class="hero-note">Free forever. Upgrade anytime.</p>
        </div>
    </section>

    <!-- Problem Section -->
    <section class="section" id="problem">
        <div class="container">
            <h2>Tired of This?</h2>
            <div class="problem-grid">
                <div class="problem-card">
                    <span class="emoji">📱</span>
                    <h3>Gallery Chaos</h3>
                    <p>Phone full of product photos. Can't find anything.</p>
                </div>
                <div class="problem-card">
                    <span class="emoji">💬</span>
                    <h3>"Price?" Messages</h3>
                    <p>Answering the same question 50 times a day.</p>
                </div>
                <div class="problem-card">
                    <span class="emoji">📝</span>
                    <h3>Lost Orders</h3>
                    <p>Orders buried in chat. Missed deliveries. Angry customers.</p>
                </div>
                <div class="problem-card">
                    <span class="emoji">🤷</span>
                    <h3>No Trust</h3>
                    <p>Customers hesitate to pay a "random WhatsApp number".</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Solution Section -->
    <section class="section section-dark" id="features">
        <div class="container">
            <h2>ZITEO Fixes Everything</h2>
            <div class="feature-grid">
                <div class="feature-card">
                    <span class="icon">🔗</span>
                    <h3>One Link Catalog</h3>
                    <p>Upload products once. Share one beautiful link. Done.</p>
                </div>
                <div class="feature-card">
                    <span class="icon">💚</span>
                    <h3>WhatsApp Orders</h3>
                    <p>Customers click "Buy" → WhatsApp opens with order details.</p>
                </div>
                <div class="feature-card">
                    <span class="icon">📊</span>
                    <h3>Order Dashboard</h3>
                    <p>See all orders in one place. Never miss a sale.</p>
                </div>
                <div class="feature-card">
                    <span class="icon">✨</span>
                    <h3>Professional Look</h3>
                    <p>Look like a brand, not a random seller.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing -->
    <section class="section" id="pricing">
        <div class="container">
            <h2>Simple Pricing</h2>
            <p class="section-subtitle">Start free. Upgrade when you grow.</p>
            <div class="pricing-grid">
                <div class="pricing-card">
                    <h3>Basic</h3>
                    <div class="price">₹49<span>/month</span></div>
                    <ul>
                        <li>15 Products</li>
                        <li>WhatsApp Orders</li>
                        <li>Basic Theme</li>
                        <li>Order Management</li>
                    </ul>
                    <a href="https://app.ziteo.in/register.php" class="btn btn-outline">Get Started</a>
                </div>
                <div class="pricing-card featured">
                    <span class="badge">Popular</span>
                    <h3>Standard</h3>
                    <div class="price">₹99<span>/month</span></div>
                    <ul>
                        <li>50 Products</li>
                        <li>Everything in Basic</li>
                        <li>Custom Colors</li>
                        <li>Basic Analytics</li>
                    </ul>
                    <a href="https://app.ziteo.in/register.php" class="btn btn-primary">Get Started</a>
                </div>
                <div class="pricing-card">
                    <h3>Pro</h3>
                    <div class="price">₹199<span>/month</span></div>
                    <ul>
                        <li>Unlimited Products</li>
                        <li>Everything in Standard</li>
                        <li>Custom Domain</li>
                        <li>Remove Branding</li>
                    </ul>
                    <a href="https://app.ziteo.in/register.php" class="btn btn-outline">Get Started</a>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA -->
    <section class="section section-cta">
        <div class="container">
            <h2>Ready to Look Professional?</h2>
            <p>Join thousands of sellers who upgraded from WhatsApp chaos.</p>
            <a href="https://app.ziteo.in/register.php" class="btn btn-primary btn-large">Create Your Free Store →</a>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p>&copy; 2026 ZITEO. Made with ❤️ in India.</p>
        </div>
    </footer>

    <script src="assets/js/main.js"></script>
</body>

</html>