<?php

/**
 * Store Footer Component
 * Shared across all pages
 */
?>
</main>

<!-- Footer -->
<footer class="store-footer">
    <div class="container">
        <div class="footer-content">
            <div class="footer-brand">
                <h3><?= e($store['name']) ?></h3>
                <p>Shop with us on WhatsApp</p>
            </div>
            <div class="footer-links">
                <a href="<?= $storeUrl ?>/">Home</a>
                <a href="<?= $storeUrl ?>/products">Products</a>
                <a href="<?= $storeUrl ?>/about">About</a>
                <a href="<?= $storeUrl ?>/wishlist">Wishlist</a>
            </div>
        </div>
        <div class="footer-bottom">
            <p>Powered by <a href="https://ziteo.in" target="_blank">ZITEO</a></p>
        </div>
    </div>
</footer>

<!-- WhatsApp Floating Button -->
<a href="https://wa.me/91<?= e($store['whatsapp']) ?>" class="whatsapp-float" target="_blank" title="Chat on WhatsApp">
    <span class="whatsapp-icon">💬</span>
    <span class="whatsapp-text">Chat</span>
</a>

<!-- Bottom Mobile Navigation -->
<nav class="bottom-nav">
    <a href="<?= $storeUrl ?>/" class="bottom-nav-item <?= $currentPage === 'home' ? 'active' : '' ?>">
        <span class="bottom-nav-icon">🏠</span>
        <span>Home</span>
    </a>
    <a href="<?= $storeUrl ?>/products" class="bottom-nav-item <?= $currentPage === 'products' ? 'active' : '' ?>">
        <span class="bottom-nav-icon">📦</span>
        <span>Products</span>
    </a>
    <a href="<?= $storeUrl ?>/search" class="bottom-nav-item <?= $currentPage === 'search' ? 'active' : '' ?>">
        <span class="bottom-nav-icon">🔍</span>
        <span>Search</span>
    </a>
    <a href="<?= $storeUrl ?>/wishlist" class="bottom-nav-item <?= $currentPage === 'wishlist' ? 'active' : '' ?>">
        <span class="bottom-nav-icon">❤️</span>
        <span>Wishlist</span>
    </a>
</nav>

<script>
    // Store ID for localStorage keys
    const STORE_ID = <?= $store['id'] ?>;
    const STORE_SLUG = '<?= e($store['slug']) ?>';

    // Initialize wishlist count
    function updateWishlistCount() {
        const wishlist = JSON.parse(localStorage.getItem('wishlist_' + STORE_ID) || '[]');
        document.querySelectorAll('#wishlistCount, .wishlist-count').forEach(el => {
            el.textContent = wishlist.length;
            el.style.display = wishlist.length > 0 ? 'flex' : 'none';
        });
    }

    // Toggle search bar
    function toggleSearch() {
        const searchBar = document.getElementById('searchBar');
        searchBar.classList.toggle('active');
        if (searchBar.classList.contains('active')) {
            document.getElementById('searchInput').focus();
        }
    }

    // Toggle mobile menu
    function toggleMobileMenu() {
        document.getElementById('mobileMenu').classList.toggle('active');
        document.body.classList.toggle('menu-open');
    }

    // Add to wishlist
    function addToWishlist(productId, productName, productImage, productPrice) {
        let wishlist = JSON.parse(localStorage.getItem('wishlist_' + STORE_ID) || '[]');

        // Check if already in wishlist
        const exists = wishlist.find(item => item.id === productId);
        if (!exists) {
            wishlist.push({
                id: productId,
                name: productName,
                image: productImage,
                price: productPrice,
                addedAt: Date.now()
            });
            localStorage.setItem('wishlist_' + STORE_ID, JSON.stringify(wishlist));
            showToast('Added to wishlist! ❤️');
        } else {
            showToast('Already in wishlist');
        }
        updateWishlistCount();
    }

    // Remove from wishlist
    function removeFromWishlist(productId) {
        let wishlist = JSON.parse(localStorage.getItem('wishlist_' + STORE_ID) || '[]');
        wishlist = wishlist.filter(item => item.id !== productId);
        localStorage.setItem('wishlist_' + STORE_ID, JSON.stringify(wishlist));
        updateWishlistCount();
        return wishlist;
    }

    // Check if in wishlist
    function isInWishlist(productId) {
        const wishlist = JSON.parse(localStorage.getItem('wishlist_' + STORE_ID) || '[]');
        return wishlist.some(item => item.id === productId);
    }

    // Toast notification
    function showToast(message) {
        const toast = document.createElement('div');
        toast.className = 'toast';
        toast.textContent = message;
        document.body.appendChild(toast);
        setTimeout(() => toast.classList.add('show'), 10);
        setTimeout(() => {
            toast.classList.remove('show');
            setTimeout(() => toast.remove(), 300);
        }, 2000);
    }

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        updateWishlistCount();
    });
</script>
</body>

</html>