<?php

/**
 * Store Header Component
 * Shared across all pages
 */
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle ?? $store['name']) ?></title>
    <meta name="description" content="<?= e($pageDescription ?? 'Shop at ' . $store['name'] . '. Order on WhatsApp.') ?>">
    <link rel="stylesheet" href="/store/assets/css/store.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: <?= e($theme['primary_color'] ?? '#25D366') ?>;
            --primary-dark: <?= e($theme['primary_dark'] ?? '#128C7E') ?>;
            --secondary: <?= e($theme['secondary_color'] ?? '#6366f1') ?>;
        }
    </style>
</head>

<body>
    <!-- Navigation -->
    <nav class="store-nav">
        <div class="container">
            <a href="<?= $storeUrl ?>/" class="nav-logo">
                <?= e($store['name']) ?>
            </a>

            <div class="nav-links">
                <a href="<?= $storeUrl ?>/" class="nav-link <?= $currentPage === 'home' ? 'active' : '' ?>">Home</a>
                <a href="<?= $storeUrl ?>/products" class="nav-link <?= $currentPage === 'products' ? 'active' : '' ?>">Products</a>
                <a href="<?= $storeUrl ?>/about" class="nav-link <?= $currentPage === 'about' ? 'active' : '' ?>">About</a>
            </div>

            <div class="nav-actions">
                <button class="nav-search-btn" onclick="toggleSearch()" title="Search">
                    🔍
                </button>
                <a href="<?= $storeUrl ?>/wishlist" class="nav-wishlist <?= $currentPage === 'wishlist' ? 'active' : '' ?>" title="Wishlist">
                    ❤️
                    <span class="wishlist-count" id="wishlistCount">0</span>
                </a>
                <button class="nav-menu-btn" onclick="toggleMobileMenu()">
                    ☰
                </button>
            </div>
        </div>

        <!-- Search Bar (Hidden by default) -->
        <div class="search-bar" id="searchBar">
            <div class="container">
                <form action="<?= $storeUrl ?>/search" method="GET" class="search-form">
                    <input type="text" name="q" placeholder="Search products..."
                        value="<?= e($_GET['q'] ?? '') ?>" autocomplete="off" id="searchInput">
                    <button type="submit">Search</button>
                    <button type="button" class="search-close" onclick="toggleSearch()">×</button>
                </form>
            </div>
        </div>
    </nav>

    <!-- Mobile Menu -->
    <div class="mobile-menu" id="mobileMenu">
        <div class="mobile-menu-header">
            <span><?= e($store['name']) ?></span>
            <button onclick="toggleMobileMenu()">×</button>
        </div>
        <a href="<?= $storeUrl ?>/" class="mobile-link">🏠 Home</a>
        <a href="<?= $storeUrl ?>/products" class="mobile-link">📦 Products</a>
        <a href="<?= $storeUrl ?>/about" class="mobile-link">ℹ️ About</a>
        <a href="<?= $storeUrl ?>/wishlist" class="mobile-link">❤️ Wishlist</a>
        <a href="<?= $storeUrl ?>/search" class="mobile-link">🔍 Search</a>
    </div>

    <main class="store-main">