<?php

/**
 * Home Page Template
 */
?>
<!-- Hero Section -->
<section class="hero">
    <div class="container">
        <div class="hero-content">
            <h1>Welcome to <?= e($store['name']) ?></h1>
            <p>Discover amazing products and shop easily via WhatsApp</p>
            <a href="<?= $storeUrl ?>/products" class="btn btn-primary btn-large">
                Shop Now →
            </a>
        </div>
    </div>
</section>

<!-- Featured Products -->
<?php if (!empty($featuredProducts)): ?>
    <section class="section featured-section">
        <div class="container">
            <div class="section-header">
                <h2>Featured Products</h2>
                <a href="<?= $storeUrl ?>/products" class="view-all">View All →</a>
            </div>
            <div class="products-grid">
                <?php foreach ($featuredProducts as $product): ?>
                    <?php include __DIR__ . '/partials/product-card.php'; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<!-- Categories -->
<?php if (!empty($categories)): ?>
    <section class="section categories-section">
        <div class="container">
            <div class="section-header">
                <h2>Shop by Category</h2>
            </div>
            <div class="categories-grid">
                <?php foreach ($categories as $category): ?>
                    <a href="<?= $storeUrl ?>/products?category=<?= $category['id'] ?>" class="category-card">
                        <span class="category-icon">📁</span>
                        <span class="category-name"><?= e($category['name']) ?></span>
                        <span class="category-count"><?= $category['product_count'] ?? 0 ?> products</span>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<!-- CTA Section -->
<section class="section cta-section">
    <div class="container">
        <div class="cta-content">
            <h2>Ready to Order?</h2>
            <p>Chat with us on WhatsApp for quick ordering and support</p>
            <a href="https://wa.me/91<?= e($store['whatsapp']) ?>" class="btn btn-whatsapp btn-large" target="_blank">
                💬 Chat on WhatsApp
            </a>
        </div>
    </div>
</section>