<?php

/**
 * Product Card Partial
 * Reusable product card component
 */
$productUrl = $storeUrl . '/product/' . $product['id'];
$productImage = $product['image'] ? '/uploads/' . $store['id'] . '/' . $product['image'] : null;
$productPrice = $product['offer_price'] ?: $product['price'];
$hasDiscount = !empty($product['offer_price']);
?>
<div class="product-card" data-product-id="<?= $product['id'] ?>">
    <a href="<?= $productUrl ?>" class="product-image-link">
        <div class="product-image">
            <?php if ($productImage): ?>
                <img src="<?= e($productImage) ?>" alt="<?= e($product['name']) ?>" loading="lazy">
            <?php else: ?>
                <div class="no-image">📦</div>
            <?php endif; ?>

            <?php if ($hasDiscount): ?>
                <?php $discount = round((($product['price'] - $product['offer_price']) / $product['price']) * 100); ?>
                <span class="discount-badge">-<?= $discount ?>%</span>
            <?php endif; ?>

            <?php if ($product['stock_status'] === 'out_of_stock'): ?>
                <span class="sold-badge">Sold Out</span>
            <?php endif; ?>
        </div>
    </a>

    <div class="product-info">
        <?php if (!empty($product['category_name'])): ?>
            <span class="product-category"><?= e($product['category_name']) ?></span>
        <?php endif; ?>

        <h3 class="product-title">
            <a href="<?= $productUrl ?>"><?= e($product['name']) ?></a>
        </h3>

        <div class="product-price">
            <?php if ($hasDiscount): ?>
                <span class="price-strike"><?= formatPrice($product['price']) ?></span>
            <?php endif; ?>
            <span class="price-current"><?= formatPrice($productPrice) ?></span>
        </div>

        <div class="product-actions">
            <button class="btn-wishlist"
                onclick="event.preventDefault(); addToWishlist(<?= $product['id'] ?>, '<?= e(addslashes($product['name'])) ?>', '<?= e($productImage) ?>', <?= $productPrice ?>)"
                title="Add to Wishlist">
                <span class="wishlist-icon">♡</span>
            </button>

            <?php if ($product['stock_status'] === 'in_stock'): ?>
                <a href="<?= $productUrl ?>" class="btn btn-primary btn-sm">View</a>
            <?php else: ?>
                <button class="btn btn-disabled btn-sm" disabled>Sold Out</button>
            <?php endif; ?>
        </div>
    </div>
</div>